@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateProtectionContainerMappingInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateProtectionContainerMappingInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Protection container mapping object.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Create protection container mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectionContainerMapping = new AzureNative.RecoveryServices.ReplicationProtectionContainerMapping("replicationProtectionContainerMapping", new()
 *     {
 *         FabricName = "cloud1",
 *         MappingName = "cloud1protectionprofile1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateProtectionContainerMappingInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1",
 *             ProviderSpecificInput =
 *             {
 *                 { "instanceType", "ReplicationProviderSpecificContainerMappingInput" },
 *             },
 *             TargetProtectionContainerId = "Microsoft Azure",
 *         },
 *         ProtectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationProtectionContainerMapping(ctx, "replicationProtectionContainerMapping", &recoveryservices.ReplicationProtectionContainerMappingArgs{
 * FabricName: pulumi.String("cloud1"),
 * MappingName: pulumi.String("cloud1protectionprofile1"),
 * Properties: &recoveryservices.CreateProtectionContainerMappingInputPropertiesArgs{
 * PolicyId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1"),
 * ProviderSpecificInput: interface{}{
 * InstanceType: pulumi.String("ReplicationProviderSpecificContainerMappingInput"),
 * },
 * TargetProtectionContainerId: pulumi.String("Microsoft Azure"),
 * },
 * ProtectionContainerName: pulumi.String("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectionContainerMapping = new ReplicationProtectionContainerMapping("replicationProtectionContainerMapping", ReplicationProtectionContainerMappingArgs.builder()
 *             .fabricName("cloud1")
 *             .mappingName("cloud1protectionprofile1")
 *             .properties(CreateProtectionContainerMappingInputPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1")
 *                 .providerSpecificInput(A2AContainerMappingInputArgs.builder()
 *                     .instanceType("ReplicationProviderSpecificContainerMappingInput")
 *                     .build())
 *                 .targetProtectionContainerId("Microsoft Azure")
 *                 .build())
 *             .protectionContainerName("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectionContainerMapping cloud1protectionprofile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}
 * ```
 * @property fabricName Fabric name.
 * @property mappingName Protection container mapping name.
 * @property properties Configure protection input properties.
 * @property protectionContainerName Protection container name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationProtectionContainerMappingArgs(
    public val fabricName: Output<String>? = null,
    public val mappingName: Output<String>? = null,
    public val properties: Output<CreateProtectionContainerMappingInputPropertiesArgs>? = null,
    public val protectionContainerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .mappingName(mappingName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectionContainerName(protectionContainerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationProtectionContainerMappingArgs].
 */
@PulumiTagMarker
public class ReplicationProtectionContainerMappingArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var mappingName: Output<String>? = null

    private var properties: Output<CreateProtectionContainerMappingInputPropertiesArgs>? = null

    private var protectionContainerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("spxutelxsvoexrlw")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Protection container mapping name.
     */
    @JvmName("sbtyhahvovlhgmib")
    public suspend fun mappingName(`value`: Output<String>) {
        this.mappingName = value
    }

    /**
     * @param value Configure protection input properties.
     */
    @JvmName("fejchrmeqjrbwoyi")
    public suspend fun properties(`value`: Output<CreateProtectionContainerMappingInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("enqjiyrwhfaacckl")
    public suspend fun protectionContainerName(`value`: Output<String>) {
        this.protectionContainerName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("lotyhgkbdlcoaorr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("mkpeciripqvfxsof")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("urjpcsxlanxanicn")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Protection container mapping name.
     */
    @JvmName("ioyfojqumfvhxbtp")
    public suspend fun mappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingName = mapped
    }

    /**
     * @param value Configure protection input properties.
     */
    @JvmName("xeghgmirrludfhpk")
    public suspend fun properties(`value`: CreateProtectionContainerMappingInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Configure protection input properties.
     */
    @JvmName("kbvquenhsaonkdty")
    public suspend fun properties(argument: suspend CreateProtectionContainerMappingInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreateProtectionContainerMappingInputPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("dxtlgvhurxmflyyl")
    public suspend fun protectionContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionContainerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("bpgyxncvrqqvljno")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("guqirrottrtrekvd")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationProtectionContainerMappingArgs =
        ReplicationProtectionContainerMappingArgs(
            fabricName = fabricName,
            mappingName = mappingName,
            properties = properties,
            protectionContainerName = protectionContainerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
}
