@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.VaultArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.IdentityDataArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.IdentityDataArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.VaultPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.VaultPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information, as returned by the resource provider.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2020-02-02, 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01, 2024-04-01, 2024-04-30-preview.
 * ## Example Usage
 * ### Create or Update Recovery Services vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.RecoveryServices.Vault("vault", new()
 *     {
 *         Identity = new AzureNative.RecoveryServices.Inputs.IdentityDataArgs
 *         {
 *             Type = AzureNative.RecoveryServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.RecoveryServices.Inputs.VaultPropertiesArgs
 *         {
 *             PublicNetworkAccess = AzureNative.RecoveryServices.PublicNetworkAccess.Enabled,
 *         },
 *         ResourceGroupName = "Default-RecoveryServices-ResourceGroup",
 *         Sku = new AzureNative.RecoveryServices.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.RecoveryServices.SkuName.Standard,
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewVault(ctx, "vault", &recoveryservices.VaultArgs{
 * 			Identity: &recoveryservices.IdentityDataArgs{
 * 				Type: pulumi.String(recoveryservices.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			Properties: &recoveryservices.VaultPropertiesArgs{
 * 				PublicNetworkAccess: pulumi.String(recoveryservices.PublicNetworkAccessEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-RecoveryServices-ResourceGroup"),
 * 			Sku: &recoveryservices.SkuArgs{
 * 				Name: pulumi.String(recoveryservices.SkuNameStandard),
 * 			},
 * 			VaultName: pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.Vault;
 * import com.pulumi.azurenative.recoveryservices.VaultArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.IdentityDataArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .identity(IdentityDataArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .publicNetworkAccess("Enabled")
 *                 .build())
 *             .resourceGroupName("Default-RecoveryServices-ResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Vault With Monitoring Setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.RecoveryServices.Vault("vault", new()
 *     {
 *         Identity = new AzureNative.RecoveryServices.Inputs.IdentityDataArgs
 *         {
 *             Type = AzureNative.RecoveryServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.RecoveryServices.Inputs.VaultPropertiesArgs
 *         {
 *             MonitoringSettings = new AzureNative.RecoveryServices.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.RecoveryServices.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = AzureNative.RecoveryServices.AlertsState.Enabled,
 *                 },
 *                 ClassicAlertSettings = new AzureNative.RecoveryServices.Inputs.ClassicAlertSettingsArgs
 *                 {
 *                     AlertsForCriticalOperations = AzureNative.RecoveryServices.AlertsState.Disabled,
 *                 },
 *             },
 *             PublicNetworkAccess = AzureNative.RecoveryServices.PublicNetworkAccess.Enabled,
 *         },
 *         ResourceGroupName = "Default-RecoveryServices-ResourceGroup",
 *         Sku = new AzureNative.RecoveryServices.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.RecoveryServices.SkuName.Standard,
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewVault(ctx, "vault", &recoveryservices.VaultArgs{
 * 			Identity: &recoveryservices.IdentityDataArgs{
 * 				Type: pulumi.String(recoveryservices.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			Properties: &recoveryservices.VaultPropertiesArgs{
 * 				MonitoringSettings: &recoveryservices.MonitoringSettingsArgs{
 * 					AzureMonitorAlertSettings: &recoveryservices.AzureMonitorAlertSettingsArgs{
 * 						AlertsForAllJobFailures: pulumi.String(recoveryservices.AlertsStateEnabled),
 * 					},
 * 					ClassicAlertSettings: &recoveryservices.ClassicAlertSettingsArgs{
 * 						AlertsForCriticalOperations: pulumi.String(recoveryservices.AlertsStateDisabled),
 * 					},
 * 				},
 * 				PublicNetworkAccess: pulumi.String(recoveryservices.PublicNetworkAccessEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-RecoveryServices-ResourceGroup"),
 * 			Sku: &recoveryservices.SkuArgs{
 * 				Name: pulumi.String(recoveryservices.SkuNameStandard),
 * 			},
 * 			VaultName: pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.Vault;
 * import com.pulumi.azurenative.recoveryservices.VaultArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.IdentityDataArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.AzureMonitorAlertSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .identity(IdentityDataArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .monitoringSettings(MonitoringSettingsArgs.builder()
 *                     .azureMonitorAlertSettings(AzureMonitorAlertSettingsArgs.builder()
 *                         .alertsForAllJobFailures("Enabled")
 *                         .build())
 *                     .classicAlertSettings(ClassicAlertSettingsArgs.builder()
 *                         .alertsForCriticalOperations("Disabled")
 *                         .build())
 *                     .build())
 *                 .publicNetworkAccess("Enabled")
 *                 .build())
 *             .resourceGroupName("Default-RecoveryServices-ResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:Vault swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}
 * ```
 * @property identity Identity for the resource.
 * @property location Resource location.
 * @property properties Properties of the vault.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Identifies the unique system identifier for each Azure resource.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class VaultArgs(
    public val identity: Output<IdentityDataArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<VaultPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.VaultArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.VaultArgs =
        com.pulumi.azurenative.recoveryservices.VaultArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var identity: Output<IdentityDataArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<VaultPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Identity for the resource.
     */
    @JvmName("celoglsplcfcoegc")
    public suspend fun identity(`value`: Output<IdentityDataArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jjcwvieejneiiwkp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the vault.
     */
    @JvmName("dwtertstwfudwuey")
    public suspend fun properties(`value`: Output<VaultPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxnlimppmgweglwq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Identifies the unique system identifier for each Azure resource.
     */
    @JvmName("tgxdtfdhsrvihagk")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("idorhiiasmhkgmdu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("axprndgoudamlvqp")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("qnjkpqwotmunvglw")
    public suspend fun identity(`value`: IdentityDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("pqdadqmideokjqxx")
    public suspend fun identity(argument: suspend IdentityDataArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bnskpvtrcpdhmcnl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the vault.
     */
    @JvmName("wcxmvesrvpnobmjs")
    public suspend fun properties(`value`: VaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the vault.
     */
    @JvmName("kdabsvbivasblryu")
    public suspend fun properties(argument: suspend VaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gnjsbkpapeqctvgh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Identifies the unique system identifier for each Azure resource.
     */
    @JvmName("ncaatjqxaksldajy")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Identifies the unique system identifier for each Azure resource.
     */
    @JvmName("vrfqlwlfoxcnlrba")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vmrkkpsgjxwjnqof")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cuwtwmsiomcpqggr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("avlqqnlqsvgttsiq")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        vaultName = vaultName,
    )
}
