@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of backup management for the backed up item.
 */
public enum class BackupManagementType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.BackupManagementType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.BackupManagementType> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.Invalid),
    AzureIaasVM(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.AzureIaasVM),
    MAB(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.MAB),
    DPM(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.DPM),
    AzureBackupServer(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.AzureBackupServer),
    AzureSql(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.AzureSql),
    AzureStorage(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.AzureStorage),
    AzureWorkload(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.AzureWorkload),
    DefaultBackup(com.pulumi.azurenative.recoveryservices.enums.BackupManagementType.DefaultBackup),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.BackupManagementType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.BackupManagementType): BackupManagementType = BackupManagementType.values().first { it.javaValue == javaType }
    }
}
