@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Health status of the backup item, evaluated based on last heartbeat received
 */
public enum class ProtectedItemHealthStatus(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus.Invalid),
    Healthy(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus.Healthy),
    Unhealthy(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus.Unhealthy),
    NotReachable(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus.NotReachable),
    IRPending(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus.IRPending),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ProtectedItemHealthStatus): ProtectedItemHealthStatus =
            ProtectedItemHealthStatus.values().first { it.javaValue == javaType }
    }
}
