@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protection state of the backup engine
 */
public enum class ProtectedItemState(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.Invalid),
    IRPending(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.IRPending),
    Protected(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.Protected),
    ProtectionError(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.ProtectionError),
    ProtectionStopped(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.ProtectionStopped),
    ProtectionPaused(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.ProtectionPaused),
    BackupsSuspended(com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState.BackupsSuspended),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ProtectedItemState): ProtectedItemState = ProtectedItemState.values().first { it.javaValue == javaType }
    }
}
