@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Backup state of this backup item.
 */
public enum class ProtectionState(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ProtectionState,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ProtectionState> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.Invalid),
    IRPending(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.IRPending),
    Protected(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.Protected),
    ProtectionError(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.ProtectionError),
    ProtectionStopped(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.ProtectionStopped),
    ProtectionPaused(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.ProtectionPaused),
    BackupsSuspended(com.pulumi.azurenative.recoveryservices.enums.ProtectionState.BackupsSuspended),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ProtectionState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ProtectionState): ProtectionState = ProtectionState.values().first { it.javaValue == javaType }
    }
}
