@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Resource Health Status
 */
public enum class ResourceHealthStatus(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus> {
    Healthy(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.Healthy),
    TransientDegraded(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.TransientDegraded),
    PersistentDegraded(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.PersistentDegraded),
    TransientUnhealthy(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.TransientUnhealthy),
    PersistentUnhealthy(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.PersistentUnhealthy),
    Invalid(com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus.Invalid),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ResourceHealthStatus): ResourceHealthStatus = ResourceHealthStatus.values().first { it.javaValue == javaType }
    }
}
