@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType.SystemAssigned),
    None(com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType.None),
    UserAssigned(com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
