@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Workload item type of the item for which intent is to be set
 */
public enum class WorkloadItemType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.Invalid),
    SQLInstance(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SQLInstance),
    SQLDataBase(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SQLDataBase),
    SAPHanaSystem(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SAPHanaSystem),
    SAPHanaDatabase(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SAPHanaDatabase),
    SAPAseSystem(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SAPAseSystem),
    SAPAseDatabase(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SAPAseDatabase),
    SAPHanaDBInstance(com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType.SAPHanaDBInstance),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.WorkloadItemType): WorkloadItemType = WorkloadItemType.values().first { it.javaValue == javaType }
    }
}
