@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of workload for the backup management
 */
public enum class WorkloadType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.WorkloadType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.WorkloadType> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.Invalid),
    VM(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.VM),
    FileFolder(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.FileFolder),
    AzureSqlDb(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.AzureSqlDb),
    SQLDB(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SQLDB),
    Exchange(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.Exchange),
    Sharepoint(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.Sharepoint),
    VMwareVM(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.VMwareVM),
    SystemState(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SystemState),
    Client(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.Client),
    GenericDataSource(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.GenericDataSource),
    SQLDataBase(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SQLDataBase),
    AzureFileShare(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.AzureFileShare),
    SAPHanaDatabase(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SAPHanaDatabase),
    SAPAseDatabase(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SAPAseDatabase),
    SAPHanaDBInstance(com.pulumi.azurenative.recoveryservices.enums.WorkloadType.SAPHanaDBInstance),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.WorkloadType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.WorkloadType): WorkloadType = WorkloadType.values().first { it.javaValue == javaType }
    }
}
