@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationEnableProtectionInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A Cross-Cluster Migration enable protection input.
 * @property fabricObjectId The fabric specific object Id of the virtual machine.
 * @property instanceType The class type.
 * Expected value is 'A2ACrossClusterMigration'.
 * @property recoveryContainerId The recovery container Id.
 */
public data class A2ACrossClusterMigrationEnableProtectionInputArgs(
    public val fabricObjectId: Output<String>? = null,
    public val instanceType: Output<String>,
    public val recoveryContainerId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationEnableProtectionInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationEnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2ACrossClusterMigrationEnableProtectionInputArgs.builder()
            .fabricObjectId(fabricObjectId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .recoveryContainerId(recoveryContainerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2ACrossClusterMigrationEnableProtectionInputArgs].
 */
@PulumiTagMarker
public class A2ACrossClusterMigrationEnableProtectionInputArgsBuilder internal constructor() {
    private var fabricObjectId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var recoveryContainerId: Output<String>? = null

    /**
     * @param value The fabric specific object Id of the virtual machine.
     */
    @JvmName("dvsbkdtavktgjbjw")
    public suspend fun fabricObjectId(`value`: Output<String>) {
        this.fabricObjectId = value
    }

    /**
     * @param value The class type.
     * Expected value is 'A2ACrossClusterMigration'.
     */
    @JvmName("ervyvflfqjfstcdc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("lovhyeyqcrjeciqt")
    public suspend fun recoveryContainerId(`value`: Output<String>) {
        this.recoveryContainerId = value
    }

    /**
     * @param value The fabric specific object Id of the virtual machine.
     */
    @JvmName("cdqoepqxlusdvmyo")
    public suspend fun fabricObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricObjectId = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'A2ACrossClusterMigration'.
     */
    @JvmName("kscllneprqsafrdq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("jfuryfvngrnicopk")
    public suspend fun recoveryContainerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryContainerId = mapped
    }

    internal fun build(): A2ACrossClusterMigrationEnableProtectionInputArgs =
        A2ACrossClusterMigrationEnableProtectionInputArgs(
            fabricObjectId = fabricObjectId,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            recoveryContainerId = recoveryContainerId,
        )
}
