@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2APolicyCreationInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SetMultiVmSyncStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A Policy creation input.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency (in minutes).
 * @property instanceType The class type.
 * Expected value is 'A2A'.
 * @property multiVmSyncStatus A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
 * @property recoveryPointHistory The duration in minutes until which the recovery points need to be stored.
 */
public data class A2APolicyCreationInputArgs(
    public val appConsistentFrequencyInMinutes: Output<Int>? = null,
    public val crashConsistentFrequencyInMinutes: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val multiVmSyncStatus: Output<Either<String, SetMultiVmSyncStatus>>,
    public val recoveryPointHistory: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2APolicyCreationInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2APolicyCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2APolicyCreationInputArgs.builder()
            .appConsistentFrequencyInMinutes(appConsistentFrequencyInMinutes?.applyValue({ args0 -> args0 }))
            .crashConsistentFrequencyInMinutes(
                crashConsistentFrequencyInMinutes?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .multiVmSyncStatus(
                multiVmSyncStatus.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .recoveryPointHistory(recoveryPointHistory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2APolicyCreationInputArgs].
 */
@PulumiTagMarker
public class A2APolicyCreationInputArgsBuilder internal constructor() {
    private var appConsistentFrequencyInMinutes: Output<Int>? = null

    private var crashConsistentFrequencyInMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var multiVmSyncStatus: Output<Either<String, SetMultiVmSyncStatus>>? = null

    private var recoveryPointHistory: Output<Int>? = null

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("mtgcmcwmilhrmydn")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.appConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("pntdjeymsxtnixuk")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.crashConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("kqvbsiqeqknvandl")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("rkvgfmgarxtdhpyc")
    public suspend fun multiVmSyncStatus(`value`: Output<Either<String, SetMultiVmSyncStatus>>) {
        this.multiVmSyncStatus = value
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("mnemhfekqxjrgruj")
    public suspend fun recoveryPointHistory(`value`: Output<Int>) {
        this.recoveryPointHistory = value
    }

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("hglbmsvfafiwbyum")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("oiuugwyefbbbndlg")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crashConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("dxolpaipqcjnrehh")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("vflhijuwdbyqimlb")
    public suspend fun multiVmSyncStatus(`value`: Either<String, SetMultiVmSyncStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("tllpiljujclyorss")
    public fun multiVmSyncStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetMultiVmSyncStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'.
     */
    @JvmName("wccngijblpjnhcle")
    public fun multiVmSyncStatus(`value`: SetMultiVmSyncStatus) {
        val toBeMapped = Either.ofRight<String, SetMultiVmSyncStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmSyncStatus = mapped
    }

    /**
     * @param value The duration in minutes until which the recovery points need to be stored.
     */
    @JvmName("grribwaxalhsgfnw")
    public suspend fun recoveryPointHistory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointHistory = mapped
    }

    internal fun build(): A2APolicyCreationInputArgs = A2APolicyCreationInputArgs(
        appConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes,
        crashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        multiVmSyncStatus = multiVmSyncStatus ?: throw PulumiNullFieldException("multiVmSyncStatus"),
        recoveryPointHistory = recoveryPointHistory,
    )
}
