@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AProtectedManagedDiskDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A2A protected managed disk details.
 * @property allowedDiskLevelOperation The disk level operations list.
 * @property dataPendingAtSourceAgentInMB The data pending at source virtual machine in MB.
 * @property dataPendingInStagingStorageAccountInMB The data pending for replication in MB at staging account.
 * @property dekKeyVaultArmId The KeyVault resource id for secret (BEK).
 * @property diskCapacityInBytes The disk capacity in bytes.
 * @property diskId The managed disk Arm id.
 * @property diskName The disk name.
 * @property diskState The disk state.
 * @property diskType The type of disk.
 * @property failoverDiskName The failover name for the managed disk.
 * @property isDiskEncrypted A value indicating whether vm has encrypted os disk or not.
 * @property isDiskKeyEncrypted A value indicating whether disk key got encrypted or not.
 * @property kekKeyVaultArmId The KeyVault resource id for key (KEK).
 * @property keyIdentifier The key URL / identifier (KEK).
 * @property monitoringJobType The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
 * @property monitoringPercentageCompletion The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
 * @property primaryDiskEncryptionSetId The primary disk encryption set Id.
 * @property primaryStagingAzureStorageAccountId The primary staging storage account.
 * @property recoveryDiskEncryptionSetId The recovery disk encryption set Id.
 * @property recoveryOrignalTargetDiskId Recovery original target disk Arm Id.
 * @property recoveryReplicaDiskAccountType The replica disk type. Its an optional value and will be same as source disk type if not user provided.
 * @property recoveryReplicaDiskId Recovery replica disk Arm Id.
 * @property recoveryResourceGroupId The recovery disk resource group Arm Id.
 * @property recoveryTargetDiskAccountType The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
 * @property recoveryTargetDiskId Recovery target disk Arm Id.
 * @property resyncRequired A value indicating whether resync is required for this disk.
 * @property secretIdentifier The secret URL / identifier (BEK).
 * @property tfoDiskName The test failover name for the managed disk.
 */
public data class A2AProtectedManagedDiskDetailsArgs(
    public val allowedDiskLevelOperation: Output<List<String>>? = null,
    public val dataPendingAtSourceAgentInMB: Output<Double>? = null,
    public val dataPendingInStagingStorageAccountInMB: Output<Double>? = null,
    public val dekKeyVaultArmId: Output<String>? = null,
    public val diskCapacityInBytes: Output<Double>? = null,
    public val diskId: Output<String>? = null,
    public val diskName: Output<String>? = null,
    public val diskState: Output<String>? = null,
    public val diskType: Output<String>? = null,
    public val failoverDiskName: Output<String>? = null,
    public val isDiskEncrypted: Output<Boolean>? = null,
    public val isDiskKeyEncrypted: Output<Boolean>? = null,
    public val kekKeyVaultArmId: Output<String>? = null,
    public val keyIdentifier: Output<String>? = null,
    public val monitoringJobType: Output<String>? = null,
    public val monitoringPercentageCompletion: Output<Int>? = null,
    public val primaryDiskEncryptionSetId: Output<String>? = null,
    public val primaryStagingAzureStorageAccountId: Output<String>? = null,
    public val recoveryDiskEncryptionSetId: Output<String>? = null,
    public val recoveryOrignalTargetDiskId: Output<String>? = null,
    public val recoveryReplicaDiskAccountType: Output<String>? = null,
    public val recoveryReplicaDiskId: Output<String>? = null,
    public val recoveryResourceGroupId: Output<String>? = null,
    public val recoveryTargetDiskAccountType: Output<String>? = null,
    public val recoveryTargetDiskId: Output<String>? = null,
    public val resyncRequired: Output<Boolean>? = null,
    public val secretIdentifier: Output<String>? = null,
    public val tfoDiskName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AProtectedManagedDiskDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AProtectedManagedDiskDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AProtectedManagedDiskDetailsArgs.builder()
            .allowedDiskLevelOperation(
                allowedDiskLevelOperation?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dataPendingAtSourceAgentInMB(dataPendingAtSourceAgentInMB?.applyValue({ args0 -> args0 }))
            .dataPendingInStagingStorageAccountInMB(
                dataPendingInStagingStorageAccountInMB?.applyValue({ args0 ->
                    args0
                }),
            )
            .dekKeyVaultArmId(dekKeyVaultArmId?.applyValue({ args0 -> args0 }))
            .diskCapacityInBytes(diskCapacityInBytes?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskState(diskState?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .failoverDiskName(failoverDiskName?.applyValue({ args0 -> args0 }))
            .isDiskEncrypted(isDiskEncrypted?.applyValue({ args0 -> args0 }))
            .isDiskKeyEncrypted(isDiskKeyEncrypted?.applyValue({ args0 -> args0 }))
            .kekKeyVaultArmId(kekKeyVaultArmId?.applyValue({ args0 -> args0 }))
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 }))
            .monitoringJobType(monitoringJobType?.applyValue({ args0 -> args0 }))
            .monitoringPercentageCompletion(monitoringPercentageCompletion?.applyValue({ args0 -> args0 }))
            .primaryDiskEncryptionSetId(primaryDiskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .primaryStagingAzureStorageAccountId(
                primaryStagingAzureStorageAccountId?.applyValue({ args0 ->
                    args0
                }),
            )
            .recoveryDiskEncryptionSetId(recoveryDiskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .recoveryOrignalTargetDiskId(recoveryOrignalTargetDiskId?.applyValue({ args0 -> args0 }))
            .recoveryReplicaDiskAccountType(recoveryReplicaDiskAccountType?.applyValue({ args0 -> args0 }))
            .recoveryReplicaDiskId(recoveryReplicaDiskId?.applyValue({ args0 -> args0 }))
            .recoveryResourceGroupId(recoveryResourceGroupId?.applyValue({ args0 -> args0 }))
            .recoveryTargetDiskAccountType(recoveryTargetDiskAccountType?.applyValue({ args0 -> args0 }))
            .recoveryTargetDiskId(recoveryTargetDiskId?.applyValue({ args0 -> args0 }))
            .resyncRequired(resyncRequired?.applyValue({ args0 -> args0 }))
            .secretIdentifier(secretIdentifier?.applyValue({ args0 -> args0 }))
            .tfoDiskName(tfoDiskName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2AProtectedManagedDiskDetailsArgs].
 */
@PulumiTagMarker
public class A2AProtectedManagedDiskDetailsArgsBuilder internal constructor() {
    private var allowedDiskLevelOperation: Output<List<String>>? = null

    private var dataPendingAtSourceAgentInMB: Output<Double>? = null

    private var dataPendingInStagingStorageAccountInMB: Output<Double>? = null

    private var dekKeyVaultArmId: Output<String>? = null

    private var diskCapacityInBytes: Output<Double>? = null

    private var diskId: Output<String>? = null

    private var diskName: Output<String>? = null

    private var diskState: Output<String>? = null

    private var diskType: Output<String>? = null

    private var failoverDiskName: Output<String>? = null

    private var isDiskEncrypted: Output<Boolean>? = null

    private var isDiskKeyEncrypted: Output<Boolean>? = null

    private var kekKeyVaultArmId: Output<String>? = null

    private var keyIdentifier: Output<String>? = null

    private var monitoringJobType: Output<String>? = null

    private var monitoringPercentageCompletion: Output<Int>? = null

    private var primaryDiskEncryptionSetId: Output<String>? = null

    private var primaryStagingAzureStorageAccountId: Output<String>? = null

    private var recoveryDiskEncryptionSetId: Output<String>? = null

    private var recoveryOrignalTargetDiskId: Output<String>? = null

    private var recoveryReplicaDiskAccountType: Output<String>? = null

    private var recoveryReplicaDiskId: Output<String>? = null

    private var recoveryResourceGroupId: Output<String>? = null

    private var recoveryTargetDiskAccountType: Output<String>? = null

    private var recoveryTargetDiskId: Output<String>? = null

    private var resyncRequired: Output<Boolean>? = null

    private var secretIdentifier: Output<String>? = null

    private var tfoDiskName: Output<String>? = null

    /**
     * @param value The disk level operations list.
     */
    @JvmName("dkyncqeiquvorxnw")
    public suspend fun allowedDiskLevelOperation(`value`: Output<List<String>>) {
        this.allowedDiskLevelOperation = value
    }

    @JvmName("qmoscmtndnuwskoa")
    public suspend fun allowedDiskLevelOperation(vararg values: Output<String>) {
        this.allowedDiskLevelOperation = Output.all(values.asList())
    }

    /**
     * @param values The disk level operations list.
     */
    @JvmName("raumvdeladipjxov")
    public suspend fun allowedDiskLevelOperation(values: List<Output<String>>) {
        this.allowedDiskLevelOperation = Output.all(values)
    }

    /**
     * @param value The data pending at source virtual machine in MB.
     */
    @JvmName("aihhihfonbjxppwn")
    public suspend fun dataPendingAtSourceAgentInMB(`value`: Output<Double>) {
        this.dataPendingAtSourceAgentInMB = value
    }

    /**
     * @param value The data pending for replication in MB at staging account.
     */
    @JvmName("luujdbicefjkeiqi")
    public suspend fun dataPendingInStagingStorageAccountInMB(`value`: Output<Double>) {
        this.dataPendingInStagingStorageAccountInMB = value
    }

    /**
     * @param value The KeyVault resource id for secret (BEK).
     */
    @JvmName("ykctvpthwjqiqjmu")
    public suspend fun dekKeyVaultArmId(`value`: Output<String>) {
        this.dekKeyVaultArmId = value
    }

    /**
     * @param value The disk capacity in bytes.
     */
    @JvmName("eqvxdpvjpapuesfn")
    public suspend fun diskCapacityInBytes(`value`: Output<Double>) {
        this.diskCapacityInBytes = value
    }

    /**
     * @param value The managed disk Arm id.
     */
    @JvmName("jheslsfkuupmjbeb")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The disk name.
     */
    @JvmName("ybyswvhobprihmpk")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value The disk state.
     */
    @JvmName("srgauicloqktngku")
    public suspend fun diskState(`value`: Output<String>) {
        this.diskState = value
    }

    /**
     * @param value The type of disk.
     */
    @JvmName("fuobaqpbqcpjgkhw")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value The failover name for the managed disk.
     */
    @JvmName("voydfslgwgpqpftd")
    public suspend fun failoverDiskName(`value`: Output<String>) {
        this.failoverDiskName = value
    }

    /**
     * @param value A value indicating whether vm has encrypted os disk or not.
     */
    @JvmName("rxgkytjsmkprtvor")
    public suspend fun isDiskEncrypted(`value`: Output<Boolean>) {
        this.isDiskEncrypted = value
    }

    /**
     * @param value A value indicating whether disk key got encrypted or not.
     */
    @JvmName("rbkvtxhdeirnhase")
    public suspend fun isDiskKeyEncrypted(`value`: Output<Boolean>) {
        this.isDiskKeyEncrypted = value
    }

    /**
     * @param value The KeyVault resource id for key (KEK).
     */
    @JvmName("ckklpidlxejfuhpe")
    public suspend fun kekKeyVaultArmId(`value`: Output<String>) {
        this.kekKeyVaultArmId = value
    }

    /**
     * @param value The key URL / identifier (KEK).
     */
    @JvmName("rygqcxprpjhhhxfu")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
     */
    @JvmName("gdioythsdwxqfbwu")
    public suspend fun monitoringJobType(`value`: Output<String>) {
        this.monitoringJobType = value
    }

    /**
     * @param value The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
     */
    @JvmName("ueahjvsamejuhmfs")
    public suspend fun monitoringPercentageCompletion(`value`: Output<Int>) {
        this.monitoringPercentageCompletion = value
    }

    /**
     * @param value The primary disk encryption set Id.
     */
    @JvmName("jpswatnxrpyxixhr")
    public suspend fun primaryDiskEncryptionSetId(`value`: Output<String>) {
        this.primaryDiskEncryptionSetId = value
    }

    /**
     * @param value The primary staging storage account.
     */
    @JvmName("vktkliwpqlntljfo")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: Output<String>) {
        this.primaryStagingAzureStorageAccountId = value
    }

    /**
     * @param value The recovery disk encryption set Id.
     */
    @JvmName("oafmcuuhtiaptphp")
    public suspend fun recoveryDiskEncryptionSetId(`value`: Output<String>) {
        this.recoveryDiskEncryptionSetId = value
    }

    /**
     * @param value Recovery original target disk Arm Id.
     */
    @JvmName("paqcmfjwxhaegeca")
    public suspend fun recoveryOrignalTargetDiskId(`value`: Output<String>) {
        this.recoveryOrignalTargetDiskId = value
    }

    /**
     * @param value The replica disk type. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("ajqeybeywqkaujpt")
    public suspend fun recoveryReplicaDiskAccountType(`value`: Output<String>) {
        this.recoveryReplicaDiskAccountType = value
    }

    /**
     * @param value Recovery replica disk Arm Id.
     */
    @JvmName("cloagtelvskpafcs")
    public suspend fun recoveryReplicaDiskId(`value`: Output<String>) {
        this.recoveryReplicaDiskId = value
    }

    /**
     * @param value The recovery disk resource group Arm Id.
     */
    @JvmName("wgwbsptttkhbreml")
    public suspend fun recoveryResourceGroupId(`value`: Output<String>) {
        this.recoveryResourceGroupId = value
    }

    /**
     * @param value The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("mtjsitfymmdbassr")
    public suspend fun recoveryTargetDiskAccountType(`value`: Output<String>) {
        this.recoveryTargetDiskAccountType = value
    }

    /**
     * @param value Recovery target disk Arm Id.
     */
    @JvmName("qdskmsflyvuimiay")
    public suspend fun recoveryTargetDiskId(`value`: Output<String>) {
        this.recoveryTargetDiskId = value
    }

    /**
     * @param value A value indicating whether resync is required for this disk.
     */
    @JvmName("plghlhfnwcyuxcjc")
    public suspend fun resyncRequired(`value`: Output<Boolean>) {
        this.resyncRequired = value
    }

    /**
     * @param value The secret URL / identifier (BEK).
     */
    @JvmName("sogsmnligvofqbka")
    public suspend fun secretIdentifier(`value`: Output<String>) {
        this.secretIdentifier = value
    }

    /**
     * @param value The test failover name for the managed disk.
     */
    @JvmName("yeovxdpcixrtcxkp")
    public suspend fun tfoDiskName(`value`: Output<String>) {
        this.tfoDiskName = value
    }

    /**
     * @param value The disk level operations list.
     */
    @JvmName("euxyevcarumcuqyn")
    public suspend fun allowedDiskLevelOperation(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedDiskLevelOperation = mapped
    }

    /**
     * @param values The disk level operations list.
     */
    @JvmName("wprlndpsucocfmcy")
    public suspend fun allowedDiskLevelOperation(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedDiskLevelOperation = mapped
    }

    /**
     * @param value The data pending at source virtual machine in MB.
     */
    @JvmName("mpgivxfkyntkrgfq")
    public suspend fun dataPendingAtSourceAgentInMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPendingAtSourceAgentInMB = mapped
    }

    /**
     * @param value The data pending for replication in MB at staging account.
     */
    @JvmName("qvaibisaoblscdhc")
    public suspend fun dataPendingInStagingStorageAccountInMB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPendingInStagingStorageAccountInMB = mapped
    }

    /**
     * @param value The KeyVault resource id for secret (BEK).
     */
    @JvmName("tnjggqgfhkyggpcw")
    public suspend fun dekKeyVaultArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dekKeyVaultArmId = mapped
    }

    /**
     * @param value The disk capacity in bytes.
     */
    @JvmName("nrmavxptywvevrid")
    public suspend fun diskCapacityInBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCapacityInBytes = mapped
    }

    /**
     * @param value The managed disk Arm id.
     */
    @JvmName("mupxkshyvhdrncom")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("dxiehysxnoxjhcim")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value The disk state.
     */
    @JvmName("wsjgokkakwcfrcyt")
    public suspend fun diskState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskState = mapped
    }

    /**
     * @param value The type of disk.
     */
    @JvmName("rgascdwkscxdqgtv")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The failover name for the managed disk.
     */
    @JvmName("sjqmuxmheirfyuqa")
    public suspend fun failoverDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverDiskName = mapped
    }

    /**
     * @param value A value indicating whether vm has encrypted os disk or not.
     */
    @JvmName("nvkrjxcslcuiqhsn")
    public suspend fun isDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDiskEncrypted = mapped
    }

    /**
     * @param value A value indicating whether disk key got encrypted or not.
     */
    @JvmName("nuerjsfbyduvhayp")
    public suspend fun isDiskKeyEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDiskKeyEncrypted = mapped
    }

    /**
     * @param value The KeyVault resource id for key (KEK).
     */
    @JvmName("hvyjwwlylduedrnn")
    public suspend fun kekKeyVaultArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekKeyVaultArmId = mapped
    }

    /**
     * @param value The key URL / identifier (KEK).
     */
    @JvmName("twthihktcsjseonp")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    /**
     * @param value The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
     */
    @JvmName("sxqckjfblhdwuion")
    public suspend fun monitoringJobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringJobType = mapped
    }

    /**
     * @param value The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
     */
    @JvmName("uvjhmllycibjimcj")
    public suspend fun monitoringPercentageCompletion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringPercentageCompletion = mapped
    }

    /**
     * @param value The primary disk encryption set Id.
     */
    @JvmName("vaeibvqocgxjikje")
    public suspend fun primaryDiskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryDiskEncryptionSetId = mapped
    }

    /**
     * @param value The primary staging storage account.
     */
    @JvmName("soepyfjsrbvgxxcq")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryStagingAzureStorageAccountId = mapped
    }

    /**
     * @param value The recovery disk encryption set Id.
     */
    @JvmName("vwcwcnhlrsuognfn")
    public suspend fun recoveryDiskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryDiskEncryptionSetId = mapped
    }

    /**
     * @param value Recovery original target disk Arm Id.
     */
    @JvmName("vwjypugpckivspog")
    public suspend fun recoveryOrignalTargetDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryOrignalTargetDiskId = mapped
    }

    /**
     * @param value The replica disk type. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("eynwbwabbjhwwnqc")
    public suspend fun recoveryReplicaDiskAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryReplicaDiskAccountType = mapped
    }

    /**
     * @param value Recovery replica disk Arm Id.
     */
    @JvmName("xsxvkdsuwixjlryx")
    public suspend fun recoveryReplicaDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryReplicaDiskId = mapped
    }

    /**
     * @param value The recovery disk resource group Arm Id.
     */
    @JvmName("dweuovipjqpnsbay")
    public suspend fun recoveryResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryResourceGroupId = mapped
    }

    /**
     * @param value The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("pboygxwkmkdodjbu")
    public suspend fun recoveryTargetDiskAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryTargetDiskAccountType = mapped
    }

    /**
     * @param value Recovery target disk Arm Id.
     */
    @JvmName("aegbralphacuhmyo")
    public suspend fun recoveryTargetDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryTargetDiskId = mapped
    }

    /**
     * @param value A value indicating whether resync is required for this disk.
     */
    @JvmName("wnkcvnnnokasvfpo")
    public suspend fun resyncRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resyncRequired = mapped
    }

    /**
     * @param value The secret URL / identifier (BEK).
     */
    @JvmName("pgtboilttlgmkwps")
    public suspend fun secretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretIdentifier = mapped
    }

    /**
     * @param value The test failover name for the managed disk.
     */
    @JvmName("cgjgrygwkcqhorka")
    public suspend fun tfoDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tfoDiskName = mapped
    }

    internal fun build(): A2AProtectedManagedDiskDetailsArgs = A2AProtectedManagedDiskDetailsArgs(
        allowedDiskLevelOperation = allowedDiskLevelOperation,
        dataPendingAtSourceAgentInMB = dataPendingAtSourceAgentInMB,
        dataPendingInStagingStorageAccountInMB = dataPendingInStagingStorageAccountInMB,
        dekKeyVaultArmId = dekKeyVaultArmId,
        diskCapacityInBytes = diskCapacityInBytes,
        diskId = diskId,
        diskName = diskName,
        diskState = diskState,
        diskType = diskType,
        failoverDiskName = failoverDiskName,
        isDiskEncrypted = isDiskEncrypted,
        isDiskKeyEncrypted = isDiskKeyEncrypted,
        kekKeyVaultArmId = kekKeyVaultArmId,
        keyIdentifier = keyIdentifier,
        monitoringJobType = monitoringJobType,
        monitoringPercentageCompletion = monitoringPercentageCompletion,
        primaryDiskEncryptionSetId = primaryDiskEncryptionSetId,
        primaryStagingAzureStorageAccountId = primaryStagingAzureStorageAccountId,
        recoveryDiskEncryptionSetId = recoveryDiskEncryptionSetId,
        recoveryOrignalTargetDiskId = recoveryOrignalTargetDiskId,
        recoveryReplicaDiskAccountType = recoveryReplicaDiskAccountType,
        recoveryReplicaDiskId = recoveryReplicaDiskId,
        recoveryResourceGroupId = recoveryResourceGroupId,
        recoveryTargetDiskAccountType = recoveryTargetDiskAccountType,
        recoveryTargetDiskId = recoveryTargetDiskId,
        resyncRequired = resyncRequired,
        secretIdentifier = secretIdentifier,
        tfoDiskName = tfoDiskName,
    )
}
