@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.MultiVmGroupCreateOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A2A provider specific settings.
 * @property clusterManagementId The cluster management Id.
 * @property failoverRecoveryPointId The recovery point Id to which the cluster was failed over.
 * @property initialPrimaryExtendedLocation The initial primary extended location.
 * @property initialPrimaryFabricLocation The initial primary fabric location.
 * @property initialPrimaryZone The initial primary availability zone.
 * @property initialRecoveryExtendedLocation The initial recovery extended location.
 * @property initialRecoveryFabricLocation The initial recovery fabric location.
 * @property initialRecoveryZone The initial recovery availability zone.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property lastRpoCalculatedTime The time (in UTC) when the last RPO value was calculated by Protection Service.
 * @property lifecycleId An id that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected cluster even though other internal Ids/ARM Id might be changing.
 * @property multiVmGroupCreateOption Whether Multi VM group is auto created or specified by user.
 * @property multiVmGroupId The multi vm group Id.
 * @property multiVmGroupName The multi vm group name.
 * @property primaryAvailabilityZone The primary availability zone.
 * @property primaryExtendedLocation The primary Extended Location.
 * @property primaryFabricLocation Primary fabric location.
 * @property recoveryAvailabilityZone The recovery availability zone.
 * @property recoveryExtendedLocation The recovery Extended Location.
 * @property recoveryFabricLocation The recovery fabric location.
 * @property rpoInSeconds The last RPO value in seconds.
 */
public data class A2AReplicationProtectionClusterDetailsArgs(
    public val clusterManagementId: Output<String>? = null,
    public val failoverRecoveryPointId: Output<String>? = null,
    public val initialPrimaryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val initialPrimaryFabricLocation: Output<String>? = null,
    public val initialPrimaryZone: Output<String>? = null,
    public val initialRecoveryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val initialRecoveryFabricLocation: Output<String>? = null,
    public val initialRecoveryZone: Output<String>? = null,
    public val instanceType: Output<String>,
    public val lastRpoCalculatedTime: Output<String>? = null,
    public val lifecycleId: Output<String>? = null,
    public val multiVmGroupCreateOption: Output<Either<String, MultiVmGroupCreateOption>>? = null,
    public val multiVmGroupId: Output<String>? = null,
    public val multiVmGroupName: Output<String>? = null,
    public val primaryAvailabilityZone: Output<String>? = null,
    public val primaryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val primaryFabricLocation: Output<String>? = null,
    public val recoveryAvailabilityZone: Output<String>? = null,
    public val recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val recoveryFabricLocation: Output<String>? = null,
    public val rpoInSeconds: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs.builder()
            .clusterManagementId(clusterManagementId?.applyValue({ args0 -> args0 }))
            .failoverRecoveryPointId(failoverRecoveryPointId?.applyValue({ args0 -> args0 }))
            .initialPrimaryExtendedLocation(
                initialPrimaryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .initialPrimaryFabricLocation(initialPrimaryFabricLocation?.applyValue({ args0 -> args0 }))
            .initialPrimaryZone(initialPrimaryZone?.applyValue({ args0 -> args0 }))
            .initialRecoveryExtendedLocation(
                initialRecoveryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .initialRecoveryFabricLocation(initialRecoveryFabricLocation?.applyValue({ args0 -> args0 }))
            .initialRecoveryZone(initialRecoveryZone?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .lastRpoCalculatedTime(lastRpoCalculatedTime?.applyValue({ args0 -> args0 }))
            .lifecycleId(lifecycleId?.applyValue({ args0 -> args0 }))
            .multiVmGroupCreateOption(
                multiVmGroupCreateOption?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .multiVmGroupId(multiVmGroupId?.applyValue({ args0 -> args0 }))
            .multiVmGroupName(multiVmGroupName?.applyValue({ args0 -> args0 }))
            .primaryAvailabilityZone(primaryAvailabilityZone?.applyValue({ args0 -> args0 }))
            .primaryExtendedLocation(
                primaryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .primaryFabricLocation(primaryFabricLocation?.applyValue({ args0 -> args0 }))
            .recoveryAvailabilityZone(recoveryAvailabilityZone?.applyValue({ args0 -> args0 }))
            .recoveryExtendedLocation(
                recoveryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .recoveryFabricLocation(recoveryFabricLocation?.applyValue({ args0 -> args0 }))
            .rpoInSeconds(rpoInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2AReplicationProtectionClusterDetailsArgs].
 */
@PulumiTagMarker
public class A2AReplicationProtectionClusterDetailsArgsBuilder internal constructor() {
    private var clusterManagementId: Output<String>? = null

    private var failoverRecoveryPointId: Output<String>? = null

    private var initialPrimaryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var initialPrimaryFabricLocation: Output<String>? = null

    private var initialPrimaryZone: Output<String>? = null

    private var initialRecoveryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var initialRecoveryFabricLocation: Output<String>? = null

    private var initialRecoveryZone: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var lastRpoCalculatedTime: Output<String>? = null

    private var lifecycleId: Output<String>? = null

    private var multiVmGroupCreateOption: Output<Either<String, MultiVmGroupCreateOption>>? = null

    private var multiVmGroupId: Output<String>? = null

    private var multiVmGroupName: Output<String>? = null

    private var primaryAvailabilityZone: Output<String>? = null

    private var primaryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var primaryFabricLocation: Output<String>? = null

    private var recoveryAvailabilityZone: Output<String>? = null

    private var recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var recoveryFabricLocation: Output<String>? = null

    private var rpoInSeconds: Output<Double>? = null

    /**
     * @param value The cluster management Id.
     */
    @JvmName("auhwbwsxngcsfhbk")
    public suspend fun clusterManagementId(`value`: Output<String>) {
        this.clusterManagementId = value
    }

    /**
     * @param value The recovery point Id to which the cluster was failed over.
     */
    @JvmName("whidedgverqojifq")
    public suspend fun failoverRecoveryPointId(`value`: Output<String>) {
        this.failoverRecoveryPointId = value
    }

    /**
     * @param value The initial primary extended location.
     */
    @JvmName("ltvnnaxxapewglbo")
    public suspend fun initialPrimaryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.initialPrimaryExtendedLocation = value
    }

    /**
     * @param value The initial primary fabric location.
     */
    @JvmName("uygbhjhyntcvnise")
    public suspend fun initialPrimaryFabricLocation(`value`: Output<String>) {
        this.initialPrimaryFabricLocation = value
    }

    /**
     * @param value The initial primary availability zone.
     */
    @JvmName("ogfvgcrvykqbpewp")
    public suspend fun initialPrimaryZone(`value`: Output<String>) {
        this.initialPrimaryZone = value
    }

    /**
     * @param value The initial recovery extended location.
     */
    @JvmName("gwwtxrlcxtslexgf")
    public suspend fun initialRecoveryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.initialRecoveryExtendedLocation = value
    }

    /**
     * @param value The initial recovery fabric location.
     */
    @JvmName("laqgpyrtdldxmfqx")
    public suspend fun initialRecoveryFabricLocation(`value`: Output<String>) {
        this.initialRecoveryFabricLocation = value
    }

    /**
     * @param value The initial recovery availability zone.
     */
    @JvmName("icvhaqrtrdsgiiyg")
    public suspend fun initialRecoveryZone(`value`: Output<String>) {
        this.initialRecoveryZone = value
    }

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("drrrnjftiogmiawt")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The time (in UTC) when the last RPO value was calculated by Protection Service.
     */
    @JvmName("tivmaqaopqgajpya")
    public suspend fun lastRpoCalculatedTime(`value`: Output<String>) {
        this.lastRpoCalculatedTime = value
    }

    /**
     * @param value An id that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected cluster even though other internal Ids/ARM Id might be changing.
     */
    @JvmName("waapittfbaevhxyk")
    public suspend fun lifecycleId(`value`: Output<String>) {
        this.lifecycleId = value
    }

    /**
     * @param value Whether Multi VM group is auto created or specified by user.
     */
    @JvmName("brwvetlqfusgqnsk")
    public suspend fun multiVmGroupCreateOption(`value`: Output<Either<String, MultiVmGroupCreateOption>>) {
        this.multiVmGroupCreateOption = value
    }

    /**
     * @param value The multi vm group Id.
     */
    @JvmName("artmowentnfcvpkr")
    public suspend fun multiVmGroupId(`value`: Output<String>) {
        this.multiVmGroupId = value
    }

    /**
     * @param value The multi vm group name.
     */
    @JvmName("hfvpnyutobunljbi")
    public suspend fun multiVmGroupName(`value`: Output<String>) {
        this.multiVmGroupName = value
    }

    /**
     * @param value The primary availability zone.
     */
    @JvmName("igkkuruoyqigbbtb")
    public suspend fun primaryAvailabilityZone(`value`: Output<String>) {
        this.primaryAvailabilityZone = value
    }

    /**
     * @param value The primary Extended Location.
     */
    @JvmName("ysjnufhptymesnyf")
    public suspend fun primaryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.primaryExtendedLocation = value
    }

    /**
     * @param value Primary fabric location.
     */
    @JvmName("gsohjnohhpapaqpq")
    public suspend fun primaryFabricLocation(`value`: Output<String>) {
        this.primaryFabricLocation = value
    }

    /**
     * @param value The recovery availability zone.
     */
    @JvmName("cgefjplnkiqwpwws")
    public suspend fun recoveryAvailabilityZone(`value`: Output<String>) {
        this.recoveryAvailabilityZone = value
    }

    /**
     * @param value The recovery Extended Location.
     */
    @JvmName("gvvddliupwqwcnay")
    public suspend fun recoveryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.recoveryExtendedLocation = value
    }

    /**
     * @param value The recovery fabric location.
     */
    @JvmName("ukwcyrjjdtrpearx")
    public suspend fun recoveryFabricLocation(`value`: Output<String>) {
        this.recoveryFabricLocation = value
    }

    /**
     * @param value The last RPO value in seconds.
     */
    @JvmName("pfrjbgafocukwdxr")
    public suspend fun rpoInSeconds(`value`: Output<Double>) {
        this.rpoInSeconds = value
    }

    /**
     * @param value The cluster management Id.
     */
    @JvmName("tsbqkgekgqvnobje")
    public suspend fun clusterManagementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterManagementId = mapped
    }

    /**
     * @param value The recovery point Id to which the cluster was failed over.
     */
    @JvmName("ypynaremyxiraavm")
    public suspend fun failoverRecoveryPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverRecoveryPointId = mapped
    }

    /**
     * @param value The initial primary extended location.
     */
    @JvmName("xqadeesmrtrdhtwb")
    public suspend fun initialPrimaryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPrimaryExtendedLocation = mapped
    }

    /**
     * @param argument The initial primary extended location.
     */
    @JvmName("ojmsdjagerpxayjk")
    public suspend fun initialPrimaryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.initialPrimaryExtendedLocation = mapped
    }

    /**
     * @param value The initial primary fabric location.
     */
    @JvmName("ltuyvhxfbwyyyndw")
    public suspend fun initialPrimaryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPrimaryFabricLocation = mapped
    }

    /**
     * @param value The initial primary availability zone.
     */
    @JvmName("vqhwhtwqvvnrgstk")
    public suspend fun initialPrimaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPrimaryZone = mapped
    }

    /**
     * @param value The initial recovery extended location.
     */
    @JvmName("kbxtmtooaiwsyucl")
    public suspend fun initialRecoveryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialRecoveryExtendedLocation = mapped
    }

    /**
     * @param argument The initial recovery extended location.
     */
    @JvmName("phkseyuntqpudcon")
    public suspend fun initialRecoveryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.initialRecoveryExtendedLocation = mapped
    }

    /**
     * @param value The initial recovery fabric location.
     */
    @JvmName("iawswgcaxmtbqnvr")
    public suspend fun initialRecoveryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialRecoveryFabricLocation = mapped
    }

    /**
     * @param value The initial recovery availability zone.
     */
    @JvmName("ghfxtoehpgwjxunx")
    public suspend fun initialRecoveryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialRecoveryZone = mapped
    }

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("bybgcvtqyanmlnoq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The time (in UTC) when the last RPO value was calculated by Protection Service.
     */
    @JvmName("tyfvcofthnhnatcw")
    public suspend fun lastRpoCalculatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRpoCalculatedTime = mapped
    }

    /**
     * @param value An id that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected cluster even though other internal Ids/ARM Id might be changing.
     */
    @JvmName("ilucswdgkkjhmcae")
    public suspend fun lifecycleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleId = mapped
    }

    /**
     * @param value Whether Multi VM group is auto created or specified by user.
     */
    @JvmName("ovutshkwrtqbjsax")
    public suspend fun multiVmGroupCreateOption(`value`: Either<String, MultiVmGroupCreateOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupCreateOption = mapped
    }

    /**
     * @param value Whether Multi VM group is auto created or specified by user.
     */
    @JvmName("cvjafapbfvllnrue")
    public fun multiVmGroupCreateOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MultiVmGroupCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmGroupCreateOption = mapped
    }

    /**
     * @param value Whether Multi VM group is auto created or specified by user.
     */
    @JvmName("efgmtiwrknhqsyrx")
    public fun multiVmGroupCreateOption(`value`: MultiVmGroupCreateOption) {
        val toBeMapped = Either.ofRight<String, MultiVmGroupCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiVmGroupCreateOption = mapped
    }

    /**
     * @param value The multi vm group Id.
     */
    @JvmName("vxfgvtoqikyktxbm")
    public suspend fun multiVmGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupId = mapped
    }

    /**
     * @param value The multi vm group name.
     */
    @JvmName("sftxmeiadfcunrhb")
    public suspend fun multiVmGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupName = mapped
    }

    /**
     * @param value The primary availability zone.
     */
    @JvmName("imxhkfynxrlmwoas")
    public suspend fun primaryAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryAvailabilityZone = mapped
    }

    /**
     * @param value The primary Extended Location.
     */
    @JvmName("oltmcxadldxtnhcc")
    public suspend fun primaryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryExtendedLocation = mapped
    }

    /**
     * @param argument The primary Extended Location.
     */
    @JvmName("pxcdaqsomyjjoqip")
    public suspend fun primaryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryExtendedLocation = mapped
    }

    /**
     * @param value Primary fabric location.
     */
    @JvmName("cqhsvqqxiofcegip")
    public suspend fun primaryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFabricLocation = mapped
    }

    /**
     * @param value The recovery availability zone.
     */
    @JvmName("noclgsdhpmepprqr")
    public suspend fun recoveryAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryAvailabilityZone = mapped
    }

    /**
     * @param value The recovery Extended Location.
     */
    @JvmName("newsijxproobjpah")
    public suspend fun recoveryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param argument The recovery Extended Location.
     */
    @JvmName("mvaingxmjfdhiwfx")
    public suspend fun recoveryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param value The recovery fabric location.
     */
    @JvmName("dwpsiccxbgoxebab")
    public suspend fun recoveryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryFabricLocation = mapped
    }

    /**
     * @param value The last RPO value in seconds.
     */
    @JvmName("fquxsuvowninrgah")
    public suspend fun rpoInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rpoInSeconds = mapped
    }

    internal fun build(): A2AReplicationProtectionClusterDetailsArgs =
        A2AReplicationProtectionClusterDetailsArgs(
            clusterManagementId = clusterManagementId,
            failoverRecoveryPointId = failoverRecoveryPointId,
            initialPrimaryExtendedLocation = initialPrimaryExtendedLocation,
            initialPrimaryFabricLocation = initialPrimaryFabricLocation,
            initialPrimaryZone = initialPrimaryZone,
            initialRecoveryExtendedLocation = initialRecoveryExtendedLocation,
            initialRecoveryFabricLocation = initialRecoveryFabricLocation,
            initialRecoveryZone = initialRecoveryZone,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            lastRpoCalculatedTime = lastRpoCalculatedTime,
            lifecycleId = lifecycleId,
            multiVmGroupCreateOption = multiVmGroupCreateOption,
            multiVmGroupId = multiVmGroupId,
            multiVmGroupName = multiVmGroupName,
            primaryAvailabilityZone = primaryAvailabilityZone,
            primaryExtendedLocation = primaryExtendedLocation,
            primaryFabricLocation = primaryFabricLocation,
            recoveryAvailabilityZone = recoveryAvailabilityZone,
            recoveryExtendedLocation = recoveryExtendedLocation,
            recoveryFabricLocation = recoveryFabricLocation,
            rpoInSeconds = rpoInSeconds,
        )
}
