@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2ASharedDiskReplicationDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A2A provider specific settings.
 * @property failoverRecoveryPointId The recovery point id to which the Virtual node was failed over.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property lastRpoCalculatedTime The time (in UTC) when the last RPO value was calculated by Protection Service.
 * @property managementId The management Id.
 * @property monitoringJobType The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
 * @property monitoringPercentageCompletion The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
 * @property primaryFabricLocation Primary fabric location.
 * @property protectedManagedDisks The list of protected managed disks.
 * @property recoveryFabricLocation The recovery fabric location.
 * @property rpoInSeconds The last RPO value in seconds.
 * @property unprotectedDisks The list of unprotected disks.
 */
public data class A2ASharedDiskReplicationDetailsArgs(
    public val failoverRecoveryPointId: Output<String>? = null,
    public val instanceType: Output<String>,
    public val lastRpoCalculatedTime: Output<String>? = null,
    public val managementId: Output<String>? = null,
    public val monitoringJobType: Output<String>? = null,
    public val monitoringPercentageCompletion: Output<Int>? = null,
    public val primaryFabricLocation: Output<String>? = null,
    public val protectedManagedDisks: Output<List<A2AProtectedManagedDiskDetailsArgs>>? = null,
    public val recoveryFabricLocation: Output<String>? = null,
    public val rpoInSeconds: Output<Double>? = null,
    public val unprotectedDisks: Output<List<A2AUnprotectedDiskDetailsArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2ASharedDiskReplicationDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2ASharedDiskReplicationDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2ASharedDiskReplicationDetailsArgs.builder()
            .failoverRecoveryPointId(failoverRecoveryPointId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .lastRpoCalculatedTime(lastRpoCalculatedTime?.applyValue({ args0 -> args0 }))
            .managementId(managementId?.applyValue({ args0 -> args0 }))
            .monitoringJobType(monitoringJobType?.applyValue({ args0 -> args0 }))
            .monitoringPercentageCompletion(monitoringPercentageCompletion?.applyValue({ args0 -> args0 }))
            .primaryFabricLocation(primaryFabricLocation?.applyValue({ args0 -> args0 }))
            .protectedManagedDisks(
                protectedManagedDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .recoveryFabricLocation(recoveryFabricLocation?.applyValue({ args0 -> args0 }))
            .rpoInSeconds(rpoInSeconds?.applyValue({ args0 -> args0 }))
            .unprotectedDisks(
                unprotectedDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [A2ASharedDiskReplicationDetailsArgs].
 */
@PulumiTagMarker
public class A2ASharedDiskReplicationDetailsArgsBuilder internal constructor() {
    private var failoverRecoveryPointId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var lastRpoCalculatedTime: Output<String>? = null

    private var managementId: Output<String>? = null

    private var monitoringJobType: Output<String>? = null

    private var monitoringPercentageCompletion: Output<Int>? = null

    private var primaryFabricLocation: Output<String>? = null

    private var protectedManagedDisks: Output<List<A2AProtectedManagedDiskDetailsArgs>>? = null

    private var recoveryFabricLocation: Output<String>? = null

    private var rpoInSeconds: Output<Double>? = null

    private var unprotectedDisks: Output<List<A2AUnprotectedDiskDetailsArgs>>? = null

    /**
     * @param value The recovery point id to which the Virtual node was failed over.
     */
    @JvmName("xhcudbgallmncxxp")
    public suspend fun failoverRecoveryPointId(`value`: Output<String>) {
        this.failoverRecoveryPointId = value
    }

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("qoqridaahxaijlbj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The time (in UTC) when the last RPO value was calculated by Protection Service.
     */
    @JvmName("cmouucmmudwthqqw")
    public suspend fun lastRpoCalculatedTime(`value`: Output<String>) {
        this.lastRpoCalculatedTime = value
    }

    /**
     * @param value The management Id.
     */
    @JvmName("imkfgrkxrplamltm")
    public suspend fun managementId(`value`: Output<String>) {
        this.managementId = value
    }

    /**
     * @param value The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
     */
    @JvmName("rgjrxixwqaqcvido")
    public suspend fun monitoringJobType(`value`: Output<String>) {
        this.monitoringJobType = value
    }

    /**
     * @param value The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
     */
    @JvmName("djbepnlwqbrtrvfw")
    public suspend fun monitoringPercentageCompletion(`value`: Output<Int>) {
        this.monitoringPercentageCompletion = value
    }

    /**
     * @param value Primary fabric location.
     */
    @JvmName("dfwylmeetbcpqkka")
    public suspend fun primaryFabricLocation(`value`: Output<String>) {
        this.primaryFabricLocation = value
    }

    /**
     * @param value The list of protected managed disks.
     */
    @JvmName("aupcfjlnbwwxpnjw")
    public suspend fun protectedManagedDisks(`value`: Output<List<A2AProtectedManagedDiskDetailsArgs>>) {
        this.protectedManagedDisks = value
    }

    @JvmName("ycwnppephfinoycl")
    public suspend fun protectedManagedDisks(vararg values: Output<A2AProtectedManagedDiskDetailsArgs>) {
        this.protectedManagedDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of protected managed disks.
     */
    @JvmName("choqdhbadhkjqyya")
    public suspend fun protectedManagedDisks(values: List<Output<A2AProtectedManagedDiskDetailsArgs>>) {
        this.protectedManagedDisks = Output.all(values)
    }

    /**
     * @param value The recovery fabric location.
     */
    @JvmName("skqopchnianpaqer")
    public suspend fun recoveryFabricLocation(`value`: Output<String>) {
        this.recoveryFabricLocation = value
    }

    /**
     * @param value The last RPO value in seconds.
     */
    @JvmName("rwkvigflpbncgemr")
    public suspend fun rpoInSeconds(`value`: Output<Double>) {
        this.rpoInSeconds = value
    }

    /**
     * @param value The list of unprotected disks.
     */
    @JvmName("mfybisvjhciqofwt")
    public suspend fun unprotectedDisks(`value`: Output<List<A2AUnprotectedDiskDetailsArgs>>) {
        this.unprotectedDisks = value
    }

    @JvmName("rtmvulosayeowaro")
    public suspend fun unprotectedDisks(vararg values: Output<A2AUnprotectedDiskDetailsArgs>) {
        this.unprotectedDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of unprotected disks.
     */
    @JvmName("fxlemisynkgihrmh")
    public suspend fun unprotectedDisks(values: List<Output<A2AUnprotectedDiskDetailsArgs>>) {
        this.unprotectedDisks = Output.all(values)
    }

    /**
     * @param value The recovery point id to which the Virtual node was failed over.
     */
    @JvmName("xuqryyhrbrjpdmgw")
    public suspend fun failoverRecoveryPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverRecoveryPointId = mapped
    }

    /**
     * @param value Gets the Instance type.
     * Expected value is 'A2A'.
     */
    @JvmName("aafqpimmtmrquwfk")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The time (in UTC) when the last RPO value was calculated by Protection Service.
     */
    @JvmName("irlehdipiiuadvjn")
    public suspend fun lastRpoCalculatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRpoCalculatedTime = mapped
    }

    /**
     * @param value The management Id.
     */
    @JvmName("agqspbryxyyfjskh")
    public suspend fun managementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementId = mapped
    }

    /**
     * @param value The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
     */
    @JvmName("kfqmahmvmvojxshv")
    public suspend fun monitoringJobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringJobType = mapped
    }

    /**
     * @param value The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
     */
    @JvmName("ledpvvdboppvsiky")
    public suspend fun monitoringPercentageCompletion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringPercentageCompletion = mapped
    }

    /**
     * @param value Primary fabric location.
     */
    @JvmName("msjkcldykvhqtysd")
    public suspend fun primaryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFabricLocation = mapped
    }

    /**
     * @param value The list of protected managed disks.
     */
    @JvmName("mwikfbxtaprloubd")
    public suspend fun protectedManagedDisks(`value`: List<A2AProtectedManagedDiskDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedManagedDisks = mapped
    }

    /**
     * @param argument The list of protected managed disks.
     */
    @JvmName("xvggbaawyqukohnr")
    public suspend fun protectedManagedDisks(argument: List<suspend A2AProtectedManagedDiskDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            A2AProtectedManagedDiskDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedManagedDisks = mapped
    }

    /**
     * @param argument The list of protected managed disks.
     */
    @JvmName("pstyikdraclpylgr")
    public suspend fun protectedManagedDisks(vararg argument: suspend A2AProtectedManagedDiskDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            A2AProtectedManagedDiskDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedManagedDisks = mapped
    }

    /**
     * @param argument The list of protected managed disks.
     */
    @JvmName("irxlawqgwqbuokcr")
    public suspend fun protectedManagedDisks(argument: suspend A2AProtectedManagedDiskDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            A2AProtectedManagedDiskDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protectedManagedDisks = mapped
    }

    /**
     * @param values The list of protected managed disks.
     */
    @JvmName("vwjjbbhhihmtsnaj")
    public suspend fun protectedManagedDisks(vararg values: A2AProtectedManagedDiskDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedManagedDisks = mapped
    }

    /**
     * @param value The recovery fabric location.
     */
    @JvmName("fwgweqmygvxttypk")
    public suspend fun recoveryFabricLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryFabricLocation = mapped
    }

    /**
     * @param value The last RPO value in seconds.
     */
    @JvmName("tyihrulbtuywtehf")
    public suspend fun rpoInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rpoInSeconds = mapped
    }

    /**
     * @param value The list of unprotected disks.
     */
    @JvmName("yxhficrqddyhxfmi")
    public suspend fun unprotectedDisks(`value`: List<A2AUnprotectedDiskDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unprotectedDisks = mapped
    }

    /**
     * @param argument The list of unprotected disks.
     */
    @JvmName("nhohodlkfsxyyjxr")
    public suspend fun unprotectedDisks(argument: List<suspend A2AUnprotectedDiskDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            A2AUnprotectedDiskDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.unprotectedDisks = mapped
    }

    /**
     * @param argument The list of unprotected disks.
     */
    @JvmName("bnckqcqyqgpdaqqq")
    public suspend fun unprotectedDisks(vararg argument: suspend A2AUnprotectedDiskDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            A2AUnprotectedDiskDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.unprotectedDisks = mapped
    }

    /**
     * @param argument The list of unprotected disks.
     */
    @JvmName("jefjlfdpnkrbdldo")
    public suspend fun unprotectedDisks(argument: suspend A2AUnprotectedDiskDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            A2AUnprotectedDiskDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.unprotectedDisks = mapped
    }

    /**
     * @param values The list of unprotected disks.
     */
    @JvmName("jnnjhqeqafhdkmwy")
    public suspend fun unprotectedDisks(vararg values: A2AUnprotectedDiskDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unprotectedDisks = mapped
    }

    internal fun build(): A2ASharedDiskReplicationDetailsArgs = A2ASharedDiskReplicationDetailsArgs(
        failoverRecoveryPointId = failoverRecoveryPointId,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        lastRpoCalculatedTime = lastRpoCalculatedTime,
        managementId = managementId,
        monitoringJobType = monitoringJobType,
        monitoringPercentageCompletion = monitoringPercentageCompletion,
        primaryFabricLocation = primaryFabricLocation,
        protectedManagedDisks = protectedManagedDisks,
        recoveryFabricLocation = recoveryFabricLocation,
        rpoInSeconds = rpoInSeconds,
        unprotectedDisks = unprotectedDisks,
    )
}
