@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AUnprotectedDiskDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.AutoProtectionOfDataDisk
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A2A unprotected disk details.
 * @property diskAutoProtectionStatus A value indicating whether the disk auto protection is enabled.
 * @property diskLunId The source lun Id for the data disk.
 */
public data class A2AUnprotectedDiskDetailsArgs(
    public val diskAutoProtectionStatus: Output<Either<String, AutoProtectionOfDataDisk>>? = null,
    public val diskLunId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AUnprotectedDiskDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AUnprotectedDiskDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AUnprotectedDiskDetailsArgs.builder()
            .diskAutoProtectionStatus(
                diskAutoProtectionStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .diskLunId(diskLunId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [A2AUnprotectedDiskDetailsArgs].
 */
@PulumiTagMarker
public class A2AUnprotectedDiskDetailsArgsBuilder internal constructor() {
    private var diskAutoProtectionStatus: Output<Either<String, AutoProtectionOfDataDisk>>? = null

    private var diskLunId: Output<Int>? = null

    /**
     * @param value A value indicating whether the disk auto protection is enabled.
     */
    @JvmName("cdpmjemsmuqvyqck")
    public suspend fun diskAutoProtectionStatus(`value`: Output<Either<String, AutoProtectionOfDataDisk>>) {
        this.diskAutoProtectionStatus = value
    }

    /**
     * @param value The source lun Id for the data disk.
     */
    @JvmName("ubbsarqqlgpjhstj")
    public suspend fun diskLunId(`value`: Output<Int>) {
        this.diskLunId = value
    }

    /**
     * @param value A value indicating whether the disk auto protection is enabled.
     */
    @JvmName("vanyuqfxohqvglxj")
    public suspend fun diskAutoProtectionStatus(`value`: Either<String, AutoProtectionOfDataDisk>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAutoProtectionStatus = mapped
    }

    /**
     * @param value A value indicating whether the disk auto protection is enabled.
     */
    @JvmName("mtjjsfsuujhcyqts")
    public fun diskAutoProtectionStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoProtectionOfDataDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskAutoProtectionStatus = mapped
    }

    /**
     * @param value A value indicating whether the disk auto protection is enabled.
     */
    @JvmName("vlsbnluppgmlajdb")
    public fun diskAutoProtectionStatus(`value`: AutoProtectionOfDataDisk) {
        val toBeMapped = Either.ofRight<String, AutoProtectionOfDataDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskAutoProtectionStatus = mapped
    }

    /**
     * @param value The source lun Id for the data disk.
     */
    @JvmName("tqetoltthmxnrffi")
    public suspend fun diskLunId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskLunId = mapped
    }

    internal fun build(): A2AUnprotectedDiskDetailsArgs = A2AUnprotectedDiskDetailsArgs(
        diskAutoProtectionStatus = diskAutoProtectionStatus,
        diskLunId = diskLunId,
    )
}
