@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSComputeVMProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Additional information for this backup item.
 * @property extendedProperties Extended Properties for Azure IaasVM Backup.
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property kpisHealths Health details of different KPIs
 * @property lastBackupStatus Last backup operation status.
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemType backup item type.
 * Expected value is 'Microsoft.Compute/virtualMachines'.
 * @property protectionState Backup state of this backup item.
 * @property protectionStatus Backup status of this backup item.
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class AzureIaaSComputeVMProtectedItemArgs(
    public val backupSetName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val extendedInfo: Output<AzureIaaSVMProtectedItemExtendedInfoArgs>? = null,
    public val extendedProperties: Output<ExtendedPropertiesArgs>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null,
    public val lastBackupStatus: Output<String>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionState>>? = null,
    public val protectionStatus: Output<String>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSComputeVMProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSComputeVMProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSComputeVMProtectedItemArgs.builder()
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedProperties(
                extendedProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .kpisHealths(
                kpisHealths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .lastBackupStatus(lastBackupStatus?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectionStatus(protectionStatus?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureIaaSComputeVMProtectedItemArgs].
 */
@PulumiTagMarker
public class AzureIaaSComputeVMProtectedItemArgsBuilder internal constructor() {
    private var backupSetName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var extendedInfo: Output<AzureIaaSVMProtectedItemExtendedInfoArgs>? = null

    private var extendedProperties: Output<ExtendedPropertiesArgs>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var kpisHealths: Output<Map<String, KPIResourceHealthDetailsArgs>>? = null

    private var lastBackupStatus: Output<String>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionState>>? = null

    private var protectionStatus: Output<String>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("yeqhnxddghjhddgl")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("gbofqhsspfqooylb")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("kpnrdtmgevbbjdkv")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("sncorkwwwvalhbea")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("adkhqtkiviqobrvw")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Additional information for this backup item.
     */
    @JvmName("uonntbbhgdfoukni")
    public suspend fun extendedInfo(`value`: Output<AzureIaaSVMProtectedItemExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Extended Properties for Azure IaasVM Backup.
     */
    @JvmName("focqildkmgaqaqcc")
    public suspend fun extendedProperties(`value`: Output<ExtendedPropertiesArgs>) {
        this.extendedProperties = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("yemtnghdrgbvuikv")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("gecdypjmgfmlibbe")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("jidtetbteurmvshr")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("xnkivvdxuodkwvab")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("sphjncdluvfuhcgi")
    public suspend fun kpisHealths(`value`: Output<Map<String, KPIResourceHealthDetailsArgs>>) {
        this.kpisHealths = value
    }

    /**
     * @param value Last backup operation status.
     */
    @JvmName("wdhasbkxgdjlsqke")
    public suspend fun lastBackupStatus(`value`: Output<String>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("epoqsnxvreuwfwya")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("gwoilnaqhpdwpkph")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("uhocrudbbtgfilmi")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'Microsoft.Compute/virtualMachines'.
     */
    @JvmName("ppyyxllpoydkicua")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("aoedolmsiagpxvrp")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionState>>) {
        this.protectionState = value
    }

    /**
     * @param value Backup status of this backup item.
     */
    @JvmName("nprbnbkradcfcsmt")
    public suspend fun protectionStatus(`value`: Output<String>) {
        this.protectionStatus = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("lybojfdrotiqhfqw")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("ejkjqwauswtnohmc")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("kpgkpkkvrynsxvfl")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("acttyevgqfnnodjr")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("iawrtdfibodhmpph")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("mjdhpkrxojbxnaps")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("fdhqdgllmiqlfbei")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("swwfwtljfakiupvu")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("melreckvfdaqihuh")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("iudinokiooxyyunv")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("ipgibqqqmdrsbdal")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("nphugesabhuktyjs")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Additional information for this backup item.
     */
    @JvmName("qqngnuwydctjlfhm")
    public suspend fun extendedInfo(`value`: AzureIaaSVMProtectedItemExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional information for this backup item.
     */
    @JvmName("xkgurhcbbvcwvkow")
    public suspend fun extendedInfo(argument: suspend AzureIaaSVMProtectedItemExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureIaaSVMProtectedItemExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Extended Properties for Azure IaasVM Backup.
     */
    @JvmName("jjrnhlkdqitfoloy")
    public suspend fun extendedProperties(`value`: ExtendedPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param argument Extended Properties for Azure IaasVM Backup.
     */
    @JvmName("axpatssfkermmshc")
    public suspend fun extendedProperties(argument: suspend ExtendedPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedProperties = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("ljitxxmqrcjdwuqb")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("ykciveirifhkuhwr")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("xtddmdyjxyfqggqs")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("kejhywbclqxgmivs")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Health details of different KPIs
     */
    @JvmName("pwbicvmggufhsnxl")
    public suspend fun kpisHealths(`value`: Map<String, KPIResourceHealthDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param argument Health details of different KPIs
     */
    @JvmName("qlpygjjmlxubbmwa")
    public suspend fun kpisHealths(vararg argument: Pair<String, suspend KPIResourceHealthDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                KPIResourceHealthDetailsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.kpisHealths = mapped
    }

    /**
     * @param values Health details of different KPIs
     */
    @JvmName("socctbxeqelthjag")
    public fun kpisHealths(vararg values: Pair<String, KPIResourceHealthDetailsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kpisHealths = mapped
    }

    /**
     * @param value Last backup operation status.
     */
    @JvmName("upmiljilnhxbgkks")
    public suspend fun lastBackupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("gndyweqydrbsruuk")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("hrmtssrarhsxfqay")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("xycjeloryhrngqwg")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'Microsoft.Compute/virtualMachines'.
     */
    @JvmName("msyalewoboykoryo")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("hnujmrmdlyhvjftk")
    public suspend fun protectionState(`value`: Either<String, ProtectionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("stpblburtmqrspec")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("ergplcqhvcwmoroq")
    public fun protectionState(`value`: ProtectionState) {
        val toBeMapped = Either.ofRight<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup status of this backup item.
     */
    @JvmName("yojdjfhhpbedepjq")
    public suspend fun protectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionStatus = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("cgkecxecfmifjdlu")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("rhxqkamtjtcsmimt")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("nuhexeeklakhjcno")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("thqqkfuvxvattant")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): AzureIaaSComputeVMProtectedItemArgs = AzureIaaSComputeVMProtectedItemArgs(
        backupSetName = backupSetName,
        containerName = containerName,
        createMode = createMode,
        deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
        deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
        extendedInfo = extendedInfo,
        extendedProperties = extendedProperties,
        isArchiveEnabled = isArchiveEnabled,
        isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
        isRehydrate = isRehydrate,
        isScheduledForDeferredDelete = isScheduledForDeferredDelete,
        kpisHealths = kpisHealths,
        lastBackupStatus = lastBackupStatus,
        lastRecoveryPoint = lastRecoveryPoint,
        policyId = policyId,
        policyName = policyName,
        protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
        protectionState = protectionState,
        protectionStatus = protectionStatus,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        sourceResourceId = sourceResourceId,
    )
}
