@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureStorageContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.AcquireStorageAccountLock
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Storage Account workload-specific container.
 * @property acquireStorageAccountLock Whether storage account lock is to be acquired for this container or not.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'StorageContainer'.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of items backed up in this container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property resourceGroup Resource group name of Recovery Services Vault.
 * @property sourceResourceId Fully qualified ARM url.
 * @property storageAccountVersion Storage account version.
 */
public data class AzureStorageContainerArgs(
    public val acquireStorageAccountLock: Output<Either<String, AcquireStorageAccountLock>>? = null,
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val containerType: Output<String>,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val protectedItemCount: Output<Double>? = null,
    public val registrationStatus: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val storageAccountVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureStorageContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureStorageContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureStorageContainerArgs.builder()
            .acquireStorageAccountLock(
                acquireStorageAccountLock?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .protectedItemCount(protectedItemCount?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .storageAccountVersion(storageAccountVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStorageContainerArgs].
 */
@PulumiTagMarker
public class AzureStorageContainerArgsBuilder internal constructor() {
    private var acquireStorageAccountLock: Output<Either<String, AcquireStorageAccountLock>>? = null

    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var containerType: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var protectableObjectType: Output<String>? = null

    private var protectedItemCount: Output<Double>? = null

    private var registrationStatus: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var storageAccountVersion: Output<String>? = null

    /**
     * @param value Whether storage account lock is to be acquired for this container or not.
     */
    @JvmName("ekrxxmkafxlekubs")
    public suspend fun acquireStorageAccountLock(`value`: Output<Either<String, AcquireStorageAccountLock>>) {
        this.acquireStorageAccountLock = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("ejknbkxplppiaicc")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'StorageContainer'.
     */
    @JvmName("fbhicgenkfqgxwrx")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("saqodpvywsbgmrby")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("thrnybioooeotutc")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("gwpuabldpqefkpqu")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Number of items backed up in this container.
     */
    @JvmName("rlxgglcbuavanlxm")
    public suspend fun protectedItemCount(`value`: Output<Double>) {
        this.protectedItemCount = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("mvirkltssumhphnh")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value Resource group name of Recovery Services Vault.
     */
    @JvmName("wsllirqbrfbkdqbm")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Fully qualified ARM url.
     */
    @JvmName("skbobvxrbmhrsugb")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Storage account version.
     */
    @JvmName("avfgivfbwyospdhk")
    public suspend fun storageAccountVersion(`value`: Output<String>) {
        this.storageAccountVersion = value
    }

    /**
     * @param value Whether storage account lock is to be acquired for this container or not.
     */
    @JvmName("xcxkexsxijiwapky")
    public suspend fun acquireStorageAccountLock(`value`: Either<String, AcquireStorageAccountLock>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acquireStorageAccountLock = mapped
    }

    /**
     * @param value Whether storage account lock is to be acquired for this container or not.
     */
    @JvmName("xpccrtyxdewaecao")
    public fun acquireStorageAccountLock(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AcquireStorageAccountLock>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acquireStorageAccountLock = mapped
    }

    /**
     * @param value Whether storage account lock is to be acquired for this container or not.
     */
    @JvmName("vxpkbyqbiqpfemvi")
    public fun acquireStorageAccountLock(`value`: AcquireStorageAccountLock) {
        val toBeMapped = Either.ofRight<String, AcquireStorageAccountLock>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acquireStorageAccountLock = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("dwylpgfdwnesbrpd")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("udhvmwadkylekkyl")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("gsncexjenfieoxkc")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'StorageContainer'.
     */
    @JvmName("ounxpchydwsrtori")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("lpjhmbapwjwrwjwk")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("vqiebvtorgfdnirt")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("bxrcttvkdwdacluv")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Number of items backed up in this container.
     */
    @JvmName("tnlbhyaiibbxfcyg")
    public suspend fun protectedItemCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemCount = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("jpmeqhnvpoismfkj")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    /**
     * @param value Resource group name of Recovery Services Vault.
     */
    @JvmName("mxdyibsvwfxwqmoi")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Fully qualified ARM url.
     */
    @JvmName("cgbepjfuxlfxbcqh")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Storage account version.
     */
    @JvmName("asqxyhulrdqwhgxn")
    public suspend fun storageAccountVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountVersion = mapped
    }

    internal fun build(): AzureStorageContainerArgs = AzureStorageContainerArgs(
        acquireStorageAccountLock = acquireStorageAccountLock,
        backupManagementType = backupManagementType,
        containerType = containerType ?: throw PulumiNullFieldException("containerType"),
        friendlyName = friendlyName,
        healthStatus = healthStatus,
        protectableObjectType = protectableObjectType,
        protectedItemCount = protectedItemCount,
        registrationStatus = registrationStatus,
        resourceGroup = resourceGroup,
        sourceResourceId = sourceResourceId,
        storageAccountVersion = storageAccountVersion,
    )
}
