@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectedItemExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information on Azure Workload for SQL specific backup item.
 * @property newestRecoveryPointInArchive The latest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPoint The oldest backup copy available for this backup item across all tiers.
 * @property oldestRecoveryPointInArchive The oldest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPointInVault The oldest backup copy available for this backup item in vault tier
 * @property policyState Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryModel Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryPointCount Number of backup copies available for this backup item.
 */
public data class AzureVmWorkloadProtectedItemExtendedInfoArgs(
    public val newestRecoveryPointInArchive: Output<String>? = null,
    public val oldestRecoveryPoint: Output<String>? = null,
    public val oldestRecoveryPointInArchive: Output<String>? = null,
    public val oldestRecoveryPointInVault: Output<String>? = null,
    public val policyState: Output<String>? = null,
    public val recoveryModel: Output<String>? = null,
    public val recoveryPointCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectedItemExtendedInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectedItemExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureVmWorkloadProtectedItemExtendedInfoArgs.builder()
            .newestRecoveryPointInArchive(newestRecoveryPointInArchive?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPoint(oldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPointInArchive(oldestRecoveryPointInArchive?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPointInVault(oldestRecoveryPointInVault?.applyValue({ args0 -> args0 }))
            .policyState(policyState?.applyValue({ args0 -> args0 }))
            .recoveryModel(recoveryModel?.applyValue({ args0 -> args0 }))
            .recoveryPointCount(recoveryPointCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureVmWorkloadProtectedItemExtendedInfoArgs].
 */
@PulumiTagMarker
public class AzureVmWorkloadProtectedItemExtendedInfoArgsBuilder internal constructor() {
    private var newestRecoveryPointInArchive: Output<String>? = null

    private var oldestRecoveryPoint: Output<String>? = null

    private var oldestRecoveryPointInArchive: Output<String>? = null

    private var oldestRecoveryPointInVault: Output<String>? = null

    private var policyState: Output<String>? = null

    private var recoveryModel: Output<String>? = null

    private var recoveryPointCount: Output<Int>? = null

    /**
     * @param value The latest backup copy available for this backup item in archive tier
     */
    @JvmName("alrxgvdggaepqdxk")
    public suspend fun newestRecoveryPointInArchive(`value`: Output<String>) {
        this.newestRecoveryPointInArchive = value
    }

    /**
     * @param value The oldest backup copy available for this backup item across all tiers.
     */
    @JvmName("vqnntiwhohankerm")
    public suspend fun oldestRecoveryPoint(`value`: Output<String>) {
        this.oldestRecoveryPoint = value
    }

    /**
     * @param value The oldest backup copy available for this backup item in archive tier
     */
    @JvmName("wddywxymgdqllpjn")
    public suspend fun oldestRecoveryPointInArchive(`value`: Output<String>) {
        this.oldestRecoveryPointInArchive = value
    }

    /**
     * @param value The oldest backup copy available for this backup item in vault tier
     */
    @JvmName("rapkosofbabcnlma")
    public suspend fun oldestRecoveryPointInVault(`value`: Output<String>) {
        this.oldestRecoveryPointInVault = value
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("ruemhxbtmjinukjm")
    public suspend fun policyState(`value`: Output<String>) {
        this.policyState = value
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("wkebfhxssyrfcixb")
    public suspend fun recoveryModel(`value`: Output<String>) {
        this.recoveryModel = value
    }

    /**
     * @param value Number of backup copies available for this backup item.
     */
    @JvmName("ldgucxugbkhwkrce")
    public suspend fun recoveryPointCount(`value`: Output<Int>) {
        this.recoveryPointCount = value
    }

    /**
     * @param value The latest backup copy available for this backup item in archive tier
     */
    @JvmName("tynivwdcqwmawbix")
    public suspend fun newestRecoveryPointInArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newestRecoveryPointInArchive = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item across all tiers.
     */
    @JvmName("umwgnoyfpqajwxbl")
    public suspend fun oldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPoint = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item in archive tier
     */
    @JvmName("hafkdyqcirelgrgc")
    public suspend fun oldestRecoveryPointInArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPointInArchive = mapped
    }

    /**
     * @param value The oldest backup copy available for this backup item in vault tier
     */
    @JvmName("gtkucmwhfismalxd")
    public suspend fun oldestRecoveryPointInVault(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPointInVault = mapped
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("mfwkgelpubimevky")
    public suspend fun policyState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyState = mapped
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("jdfalcnbjejaaaqi")
    public suspend fun recoveryModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryModel = mapped
    }

    /**
     * @param value Number of backup copies available for this backup item.
     */
    @JvmName("jflqeandsdeqtbuu")
    public suspend fun recoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointCount = mapped
    }

    internal fun build(): AzureVmWorkloadProtectedItemExtendedInfoArgs =
        AzureVmWorkloadProtectedItemExtendedInfoArgs(
            newestRecoveryPointInArchive = newestRecoveryPointInArchive,
            oldestRecoveryPoint = oldestRecoveryPoint,
            oldestRecoveryPointInArchive = oldestRecoveryPointInArchive,
            oldestRecoveryPointInVault = oldestRecoveryPointInVault,
            policyState = policyState,
            recoveryModel = recoveryModel,
            recoveryPointCount = recoveryPointCount,
        )
}
