@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Extended information of the container.
 * @property hostServerName Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
 * @property inquiryInfo Inquiry Status for the container.
 * @property nodesList List of the nodes in case of distributed container.
 */
public data class AzureWorkloadContainerExtendedInfoArgs(
    public val hostServerName: Output<String>? = null,
    public val inquiryInfo: Output<InquiryInfoArgs>? = null,
    public val nodesList: Output<List<DistributedNodesInfoArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerExtendedInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerExtendedInfoArgs.builder()
            .hostServerName(hostServerName?.applyValue({ args0 -> args0 }))
            .inquiryInfo(inquiryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodesList(
                nodesList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureWorkloadContainerExtendedInfoArgs].
 */
@PulumiTagMarker
public class AzureWorkloadContainerExtendedInfoArgsBuilder internal constructor() {
    private var hostServerName: Output<String>? = null

    private var inquiryInfo: Output<InquiryInfoArgs>? = null

    private var nodesList: Output<List<DistributedNodesInfoArgs>>? = null

    /**
     * @param value Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
     */
    @JvmName("nhicapabskciwvjs")
    public suspend fun hostServerName(`value`: Output<String>) {
        this.hostServerName = value
    }

    /**
     * @param value Inquiry Status for the container.
     */
    @JvmName("cdyjopdtlbcdefio")
    public suspend fun inquiryInfo(`value`: Output<InquiryInfoArgs>) {
        this.inquiryInfo = value
    }

    /**
     * @param value List of the nodes in case of distributed container.
     */
    @JvmName("bqwgprvnqonuedgs")
    public suspend fun nodesList(`value`: Output<List<DistributedNodesInfoArgs>>) {
        this.nodesList = value
    }

    @JvmName("ojfacwblccuuhjjj")
    public suspend fun nodesList(vararg values: Output<DistributedNodesInfoArgs>) {
        this.nodesList = Output.all(values.asList())
    }

    /**
     * @param values List of the nodes in case of distributed container.
     */
    @JvmName("yurcgfgplmweldjx")
    public suspend fun nodesList(values: List<Output<DistributedNodesInfoArgs>>) {
        this.nodesList = Output.all(values)
    }

    /**
     * @param value Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
     */
    @JvmName("pioexogjafsvsrbp")
    public suspend fun hostServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostServerName = mapped
    }

    /**
     * @param value Inquiry Status for the container.
     */
    @JvmName("hvkeydywjqiyyysi")
    public suspend fun inquiryInfo(`value`: InquiryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inquiryInfo = mapped
    }

    /**
     * @param argument Inquiry Status for the container.
     */
    @JvmName("tbaaupkryeafjnhs")
    public suspend fun inquiryInfo(argument: suspend InquiryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = InquiryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inquiryInfo = mapped
    }

    /**
     * @param value List of the nodes in case of distributed container.
     */
    @JvmName("tmhmgbvobsdefhce")
    public suspend fun nodesList(`value`: List<DistributedNodesInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("aexexbciqgdhktal")
    public suspend fun nodesList(argument: List<suspend DistributedNodesInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributedNodesInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("hhppctcjwmhreehl")
    public suspend fun nodesList(vararg argument: suspend DistributedNodesInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributedNodesInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param argument List of the nodes in case of distributed container.
     */
    @JvmName("urfdyliisfpctwxh")
    public suspend fun nodesList(argument: suspend DistributedNodesInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DistributedNodesInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodesList = mapped
    }

    /**
     * @param values List of the nodes in case of distributed container.
     */
    @JvmName("txanceyogjrmpxoy")
    public suspend fun nodesList(vararg values: DistributedNodesInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodesList = mapped
    }

    internal fun build(): AzureWorkloadContainerExtendedInfoArgs =
        AzureWorkloadContainerExtendedInfoArgs(
            hostServerName = hostServerName,
            inquiryInfo = inquiryInfo,
            nodesList = nodesList,
        )
}
