@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CrossSubscriptionRestoreSettingsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CrossSubscriptionRestoreState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for Cross Subscription Restore Settings
 * @property crossSubscriptionRestoreState
 */
public data class CrossSubscriptionRestoreSettingsArgs(
    public val crossSubscriptionRestoreState: Output<Either<String, CrossSubscriptionRestoreState>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CrossSubscriptionRestoreSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.CrossSubscriptionRestoreSettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CrossSubscriptionRestoreSettingsArgs.builder()
            .crossSubscriptionRestoreState(
                crossSubscriptionRestoreState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [CrossSubscriptionRestoreSettingsArgs].
 */
@PulumiTagMarker
public class CrossSubscriptionRestoreSettingsArgsBuilder internal constructor() {
    private var crossSubscriptionRestoreState: Output<Either<String, CrossSubscriptionRestoreState>>? =
        null

    /**
     * @param value
     */
    @JvmName("qdjgnlnthjvluyop")
    public suspend fun crossSubscriptionRestoreState(`value`: Output<Either<String, CrossSubscriptionRestoreState>>) {
        this.crossSubscriptionRestoreState = value
    }

    /**
     * @param value
     */
    @JvmName("udwyursktvwgxfpo")
    public suspend fun crossSubscriptionRestoreState(`value`: Either<String, CrossSubscriptionRestoreState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSubscriptionRestoreState = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbiqdokrqwehlcmr")
    public fun crossSubscriptionRestoreState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CrossSubscriptionRestoreState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossSubscriptionRestoreState = mapped
    }

    /**
     * @param value
     */
    @JvmName("udqeborctgbabwpk")
    public fun crossSubscriptionRestoreState(`value`: CrossSubscriptionRestoreState) {
        val toBeMapped = Either.ofRight<String, CrossSubscriptionRestoreState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossSubscriptionRestoreState = mapped
    }

    internal fun build(): CrossSubscriptionRestoreSettingsArgs = CrossSubscriptionRestoreSettingsArgs(
        crossSubscriptionRestoreState = crossSubscriptionRestoreState,
    )
}
