@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CurrentScenarioDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Current scenario details of the protected entity.
 * @property jobId ARM Id of the job being executed.
 * @property scenarioName Scenario name.
 * @property startTime Start time of the workflow.
 */
public data class CurrentScenarioDetailsArgs(
    public val jobId: Output<String>? = null,
    public val scenarioName: Output<String>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CurrentScenarioDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.CurrentScenarioDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CurrentScenarioDetailsArgs.builder()
            .jobId(jobId?.applyValue({ args0 -> args0 }))
            .scenarioName(scenarioName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CurrentScenarioDetailsArgs].
 */
@PulumiTagMarker
public class CurrentScenarioDetailsArgsBuilder internal constructor() {
    private var jobId: Output<String>? = null

    private var scenarioName: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value ARM Id of the job being executed.
     */
    @JvmName("usqvkaimieixnprm")
    public suspend fun jobId(`value`: Output<String>) {
        this.jobId = value
    }

    /**
     * @param value Scenario name.
     */
    @JvmName("xmnackoojqltpvco")
    public suspend fun scenarioName(`value`: Output<String>) {
        this.scenarioName = value
    }

    /**
     * @param value Start time of the workflow.
     */
    @JvmName("orqrvqyetwndmkdd")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value ARM Id of the job being executed.
     */
    @JvmName("tunmhydmlexmhuop")
    public suspend fun jobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobId = mapped
    }

    /**
     * @param value Scenario name.
     */
    @JvmName("naxcndrerwfgglbk")
    public suspend fun scenarioName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scenarioName = mapped
    }

    /**
     * @param value Start time of the workflow.
     */
    @JvmName("fsnpxnjaawnyflnt")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): CurrentScenarioDetailsArgs = CurrentScenarioDetailsArgs(
        jobId = jobId,
        scenarioName = scenarioName,
        startTime = startTime,
    )
}
