@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DPMContainerExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information of the DPMContainer.
 * @property lastRefreshedAt Last refresh time of the DPMContainer.
 */
public data class DPMContainerExtendedInfoArgs(
    public val lastRefreshedAt: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DPMContainerExtendedInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DPMContainerExtendedInfoArgs = com.pulumi.azurenative.recoveryservices.inputs.DPMContainerExtendedInfoArgs.builder()
        .lastRefreshedAt(lastRefreshedAt?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DPMContainerExtendedInfoArgs].
 */
@PulumiTagMarker
public class DPMContainerExtendedInfoArgsBuilder internal constructor() {
    private var lastRefreshedAt: Output<String>? = null

    /**
     * @param value Last refresh time of the DPMContainer.
     */
    @JvmName("wjkqxesfubtajqec")
    public suspend fun lastRefreshedAt(`value`: Output<String>) {
        this.lastRefreshedAt = value
    }

    /**
     * @param value Last refresh time of the DPMContainer.
     */
    @JvmName("smdmdvueyxtpufmu")
    public suspend fun lastRefreshedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRefreshedAt = mapped
    }

    internal fun build(): DPMContainerExtendedInfoArgs = DPMContainerExtendedInfoArgs(
        lastRefreshedAt = lastRefreshedAt,
    )
}
