@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DiskExclusionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property diskLunList List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
 * @property isInclusionList Flag to indicate whether DiskLunList is to be included/ excluded from backup.
 */
public data class DiskExclusionPropertiesArgs(
    public val diskLunList: Output<List<Int>>? = null,
    public val isInclusionList: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DiskExclusionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DiskExclusionPropertiesArgs = com.pulumi.azurenative.recoveryservices.inputs.DiskExclusionPropertiesArgs.builder()
        .diskLunList(diskLunList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .isInclusionList(isInclusionList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskExclusionPropertiesArgs].
 */
@PulumiTagMarker
public class DiskExclusionPropertiesArgsBuilder internal constructor() {
    private var diskLunList: Output<List<Int>>? = null

    private var isInclusionList: Output<Boolean>? = null

    /**
     * @param value List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("sfrbiiwyrgoqggaf")
    public suspend fun diskLunList(`value`: Output<List<Int>>) {
        this.diskLunList = value
    }

    @JvmName("jyiqwxsglqwbqpyq")
    public suspend fun diskLunList(vararg values: Output<Int>) {
        this.diskLunList = Output.all(values.asList())
    }

    /**
     * @param values List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("ewuoclkqcmyapnuq")
    public suspend fun diskLunList(values: List<Output<Int>>) {
        this.diskLunList = Output.all(values)
    }

    /**
     * @param value Flag to indicate whether DiskLunList is to be included/ excluded from backup.
     */
    @JvmName("nkcmvcfytxhguoia")
    public suspend fun isInclusionList(`value`: Output<Boolean>) {
        this.isInclusionList = value
    }

    /**
     * @param value List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("vlcgpbovtnubjqyo")
    public suspend fun diskLunList(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskLunList = mapped
    }

    /**
     * @param values List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
     */
    @JvmName("gcfgerbxrgybepbm")
    public suspend fun diskLunList(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskLunList = mapped
    }

    /**
     * @param value Flag to indicate whether DiskLunList is to be included/ excluded from backup.
     */
    @JvmName("oqmvioodqcawrujo")
    public suspend fun isInclusionList(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isInclusionList = mapped
    }

    internal fun build(): DiskExclusionPropertiesArgs = DiskExclusionPropertiesArgs(
        diskLunList = diskLunList,
        isInclusionList = isInclusionList,
    )
}
