@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.EnableMigrationInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Enable migration input properties.
 * @property policyId The policy Id.
 * @property providerSpecificDetails The provider specific details.
 */
public data class EnableMigrationInputPropertiesArgs(
    public val policyId: Output<String>,
    public val providerSpecificDetails: Output<VMwareCbtEnableMigrationInputArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.EnableMigrationInputPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.EnableMigrationInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.EnableMigrationInputPropertiesArgs.builder()
            .policyId(policyId.applyValue({ args0 -> args0 }))
            .providerSpecificDetails(
                providerSpecificDetails.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EnableMigrationInputPropertiesArgs].
 */
@PulumiTagMarker
public class EnableMigrationInputPropertiesArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var providerSpecificDetails: Output<VMwareCbtEnableMigrationInputArgs>? = null

    /**
     * @param value The policy Id.
     */
    @JvmName("vofbsymrhxpnmvux")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The provider specific details.
     */
    @JvmName("rrfoloynwouyagdw")
    public suspend fun providerSpecificDetails(`value`: Output<VMwareCbtEnableMigrationInputArgs>) {
        this.providerSpecificDetails = value
    }

    /**
     * @param value The policy Id.
     */
    @JvmName("iriulttexemfafny")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The provider specific details.
     */
    @JvmName("stobbewmfihxxggj")
    public suspend fun providerSpecificDetails(`value`: VMwareCbtEnableMigrationInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerSpecificDetails = mapped
    }

    /**
     * @param argument The provider specific details.
     */
    @JvmName("vdbjavytbexrpekv")
    public suspend fun providerSpecificDetails(argument: suspend VMwareCbtEnableMigrationInputArgsBuilder.() -> Unit) {
        val toBeMapped = VMwareCbtEnableMigrationInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.providerSpecificDetails = mapped
    }

    internal fun build(): EnableMigrationInputPropertiesArgs = EnableMigrationInputPropertiesArgs(
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        providerSpecificDetails = providerSpecificDetails ?: throw
            PulumiNullFieldException("providerSpecificDetails"),
    )
}
