@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetProtectedItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Container name associated with the backed up item.
 * @property fabricName Fabric name associated with the backed up item.
 * @property filter OData filter options.
 * @property protectedItemName Backed up item name whose details are to be fetched.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetProtectedItemPlainArgs(
    public val containerName: String,
    public val fabricName: String,
    public val filter: String? = null,
    public val protectedItemName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetProtectedItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetProtectedItemPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetProtectedItemPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .fabricName(fabricName.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .protectedItemName(protectedItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtectedItemPlainArgs].
 */
@PulumiTagMarker
public class GetProtectedItemPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var fabricName: String? = null

    private var filter: String? = null

    private var protectedItemName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value Container name associated with the backed up item.
     */
    @JvmName("ttucgpvwbkoxygqo")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Fabric name associated with the backed up item.
     */
    @JvmName("ddvdgbckxlveyvsp")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value OData filter options.
     */
    @JvmName("rpmlmlqmwqumhfta")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value Backed up item name whose details are to be fetched.
     */
    @JvmName("ockfituedrkvsbcr")
    public suspend fun protectedItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectedItemName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("rdwyekhamvrbxulb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("vtpusptpbpfhnwrt")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetProtectedItemPlainArgs = GetProtectedItemPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        filter = filter,
        protectedItemName = protectedItemName ?: throw PulumiNullFieldException("protectedItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
