@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationMigrationItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric unique name.
 * @property migrationItemName Migration item name.
 * @property protectionContainerName Protection container name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationMigrationItemPlainArgs(
    public val fabricName: String,
    public val migrationItemName: String,
    public val protectionContainerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationMigrationItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetReplicationMigrationItemPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationMigrationItemPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .migrationItemName(migrationItemName.let({ args0 -> args0 }))
            .protectionContainerName(protectionContainerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationMigrationItemPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationMigrationItemPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var migrationItemName: String? = null

    private var protectionContainerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Fabric unique name.
     */
    @JvmName("rhoalopenovwetbh")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Migration item name.
     */
    @JvmName("jqixhqkkcuedlqfv")
    public suspend fun migrationItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrationItemName = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("shjnqdiuipojsvjo")
    public suspend fun protectionContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectionContainerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("lwlnvdcxgjcayikt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("vhielmcydjqcewiu")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationMigrationItemPlainArgs = GetReplicationMigrationItemPlainArgs(
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        migrationItemName = migrationItemName ?: throw PulumiNullFieldException("migrationItemName"),
        protectionContainerName = protectionContainerName ?: throw
            PulumiNullFieldException("protectionContainerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
