@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name.
 * @property protectionContainerName Protection container name.
 * @property replicationProtectionClusterName Replication protection cluster name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationProtectionClusterPlainArgs(
    public val fabricName: String,
    public val protectionContainerName: String,
    public val replicationProtectionClusterName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionClusterPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectionClusterPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .protectionContainerName(protectionContainerName.let({ args0 -> args0 }))
            .replicationProtectionClusterName(replicationProtectionClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationProtectionClusterPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationProtectionClusterPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var protectionContainerName: String? = null

    private var replicationProtectionClusterName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("wkiddqcgitjcuaim")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("vprjgujcigunbagc")
    public suspend fun protectionContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectionContainerName = mapped
    }

    /**
     * @param value Replication protection cluster name.
     */
    @JvmName("bcmadxknrvkysngk")
    public suspend fun replicationProtectionClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationProtectionClusterName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("igpnjtgswsifjvwb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ddxunllqkjcofcci")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationProtectionClusterPlainArgs =
        GetReplicationProtectionClusterPlainArgs(
            fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
            protectionContainerName = protectionContainerName ?: throw
                PulumiNullFieldException("protectionContainerName"),
            replicationProtectionClusterName = replicationProtectionClusterName ?: throw
                PulumiNullFieldException("replicationProtectionClusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
