@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recoveryPlanName Name of the recovery plan.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationRecoveryPlanPlainArgs(
    public val recoveryPlanName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryPlanPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryPlanPlainArgs.builder()
            .recoveryPlanName(recoveryPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationRecoveryPlanPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationRecoveryPlanPlainArgsBuilder internal constructor() {
    private var recoveryPlanName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Name of the recovery plan.
     */
    @JvmName("ukvrbdiyqojbxpba")
    public suspend fun recoveryPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.recoveryPlanName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("okktdsuconpmpryu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("orlhkyqbdngrwdvv")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationRecoveryPlanPlainArgs = GetReplicationRecoveryPlanPlainArgs(
        recoveryPlanName = recoveryPlanName ?: throw PulumiNullFieldException("recoveryPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
