@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.HealthErrorArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.HealthErrorCustomerResolvability
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Health Error.
 * @property creationTimeUtc Error creation time (UTC).
 * @property customerResolvability Value indicating whether the health error is customer resolvable.
 * @property entityId ID of the entity.
 * @property errorCategory Category of error.
 * @property errorCode Error code.
 * @property errorId The health error unique id.
 * @property errorLevel Level of error.
 * @property errorMessage Error message.
 * @property errorSource Source of error.
 * @property errorType Type of error.
 * @property innerHealthErrors The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
 * @property possibleCauses Possible causes of error.
 * @property recommendedAction Recommended action to resolve error.
 * @property recoveryProviderErrorMessage DRA error message.
 * @property summaryMessage Summary message of the entity.
 */
public data class HealthErrorArgs(
    public val creationTimeUtc: Output<String>? = null,
    public val customerResolvability: Output<Either<String, HealthErrorCustomerResolvability>>? =
        null,
    public val entityId: Output<String>? = null,
    public val errorCategory: Output<String>? = null,
    public val errorCode: Output<String>? = null,
    public val errorId: Output<String>? = null,
    public val errorLevel: Output<String>? = null,
    public val errorMessage: Output<String>? = null,
    public val errorSource: Output<String>? = null,
    public val errorType: Output<String>? = null,
    public val innerHealthErrors: Output<List<InnerHealthErrorArgs>>? = null,
    public val possibleCauses: Output<String>? = null,
    public val recommendedAction: Output<String>? = null,
    public val recoveryProviderErrorMessage: Output<String>? = null,
    public val summaryMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.HealthErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.HealthErrorArgs =
        com.pulumi.azurenative.recoveryservices.inputs.HealthErrorArgs.builder()
            .creationTimeUtc(creationTimeUtc?.applyValue({ args0 -> args0 }))
            .customerResolvability(
                customerResolvability?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .entityId(entityId?.applyValue({ args0 -> args0 }))
            .errorCategory(errorCategory?.applyValue({ args0 -> args0 }))
            .errorCode(errorCode?.applyValue({ args0 -> args0 }))
            .errorId(errorId?.applyValue({ args0 -> args0 }))
            .errorLevel(errorLevel?.applyValue({ args0 -> args0 }))
            .errorMessage(errorMessage?.applyValue({ args0 -> args0 }))
            .errorSource(errorSource?.applyValue({ args0 -> args0 }))
            .errorType(errorType?.applyValue({ args0 -> args0 }))
            .innerHealthErrors(
                innerHealthErrors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .possibleCauses(possibleCauses?.applyValue({ args0 -> args0 }))
            .recommendedAction(recommendedAction?.applyValue({ args0 -> args0 }))
            .recoveryProviderErrorMessage(recoveryProviderErrorMessage?.applyValue({ args0 -> args0 }))
            .summaryMessage(summaryMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HealthErrorArgs].
 */
@PulumiTagMarker
public class HealthErrorArgsBuilder internal constructor() {
    private var creationTimeUtc: Output<String>? = null

    private var customerResolvability: Output<Either<String, HealthErrorCustomerResolvability>>? =
        null

    private var entityId: Output<String>? = null

    private var errorCategory: Output<String>? = null

    private var errorCode: Output<String>? = null

    private var errorId: Output<String>? = null

    private var errorLevel: Output<String>? = null

    private var errorMessage: Output<String>? = null

    private var errorSource: Output<String>? = null

    private var errorType: Output<String>? = null

    private var innerHealthErrors: Output<List<InnerHealthErrorArgs>>? = null

    private var possibleCauses: Output<String>? = null

    private var recommendedAction: Output<String>? = null

    private var recoveryProviderErrorMessage: Output<String>? = null

    private var summaryMessage: Output<String>? = null

    /**
     * @param value Error creation time (UTC).
     */
    @JvmName("nsrawatfdxdaqvaa")
    public suspend fun creationTimeUtc(`value`: Output<String>) {
        this.creationTimeUtc = value
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("gbjhfafdhrjdwihr")
    public suspend fun customerResolvability(`value`: Output<Either<String, HealthErrorCustomerResolvability>>) {
        this.customerResolvability = value
    }

    /**
     * @param value ID of the entity.
     */
    @JvmName("onjdkpclkyckgisp")
    public suspend fun entityId(`value`: Output<String>) {
        this.entityId = value
    }

    /**
     * @param value Category of error.
     */
    @JvmName("lhakpaihkxmkkout")
    public suspend fun errorCategory(`value`: Output<String>) {
        this.errorCategory = value
    }

    /**
     * @param value Error code.
     */
    @JvmName("grkcsikaokxwevtm")
    public suspend fun errorCode(`value`: Output<String>) {
        this.errorCode = value
    }

    /**
     * @param value The health error unique id.
     */
    @JvmName("jjuqhhubrfkifiuc")
    public suspend fun errorId(`value`: Output<String>) {
        this.errorId = value
    }

    /**
     * @param value Level of error.
     */
    @JvmName("svwsvffkiftkjodl")
    public suspend fun errorLevel(`value`: Output<String>) {
        this.errorLevel = value
    }

    /**
     * @param value Error message.
     */
    @JvmName("cxlufnqyejjnfbqw")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Source of error.
     */
    @JvmName("fdldxurnaphmmmbo")
    public suspend fun errorSource(`value`: Output<String>) {
        this.errorSource = value
    }

    /**
     * @param value Type of error.
     */
    @JvmName("lxfaitsjivdujsik")
    public suspend fun errorType(`value`: Output<String>) {
        this.errorType = value
    }

    /**
     * @param value The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("frxfnvpclppglcpq")
    public suspend fun innerHealthErrors(`value`: Output<List<InnerHealthErrorArgs>>) {
        this.innerHealthErrors = value
    }

    @JvmName("mflmmotevuhhjihi")
    public suspend fun innerHealthErrors(vararg values: Output<InnerHealthErrorArgs>) {
        this.innerHealthErrors = Output.all(values.asList())
    }

    /**
     * @param values The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("seqwhxbrvlwkndsd")
    public suspend fun innerHealthErrors(values: List<Output<InnerHealthErrorArgs>>) {
        this.innerHealthErrors = Output.all(values)
    }

    /**
     * @param value Possible causes of error.
     */
    @JvmName("gygewdecukonbxqi")
    public suspend fun possibleCauses(`value`: Output<String>) {
        this.possibleCauses = value
    }

    /**
     * @param value Recommended action to resolve error.
     */
    @JvmName("goewiwfgcepmbjvg")
    public suspend fun recommendedAction(`value`: Output<String>) {
        this.recommendedAction = value
    }

    /**
     * @param value DRA error message.
     */
    @JvmName("ieviorjvtajovjyj")
    public suspend fun recoveryProviderErrorMessage(`value`: Output<String>) {
        this.recoveryProviderErrorMessage = value
    }

    /**
     * @param value Summary message of the entity.
     */
    @JvmName("dkydqmscmkpiatsk")
    public suspend fun summaryMessage(`value`: Output<String>) {
        this.summaryMessage = value
    }

    /**
     * @param value Error creation time (UTC).
     */
    @JvmName("mikcrgubdvtsdvad")
    public suspend fun creationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationTimeUtc = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("cvxefoyemhewxjfp")
    public suspend fun customerResolvability(`value`: Either<String, HealthErrorCustomerResolvability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("jcgvgsbgfhamrpht")
    public fun customerResolvability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HealthErrorCustomerResolvability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("gxvynbvknhbhtefe")
    public fun customerResolvability(`value`: HealthErrorCustomerResolvability) {
        val toBeMapped = Either.ofRight<String, HealthErrorCustomerResolvability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value ID of the entity.
     */
    @JvmName("wpbylquhgbdurxfp")
    public suspend fun entityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityId = mapped
    }

    /**
     * @param value Category of error.
     */
    @JvmName("icxmrnvnxttexgfj")
    public suspend fun errorCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCategory = mapped
    }

    /**
     * @param value Error code.
     */
    @JvmName("qvhyjimgchsodujo")
    public suspend fun errorCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value The health error unique id.
     */
    @JvmName("ygtdslidomfdshmn")
    public suspend fun errorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorId = mapped
    }

    /**
     * @param value Level of error.
     */
    @JvmName("wypdswxjgyvlcwyv")
    public suspend fun errorLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorLevel = mapped
    }

    /**
     * @param value Error message.
     */
    @JvmName("frhiojnrtkafhnjk")
    public suspend fun errorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    /**
     * @param value Source of error.
     */
    @JvmName("pocjiynxswxlredw")
    public suspend fun errorSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorSource = mapped
    }

    /**
     * @param value Type of error.
     */
    @JvmName("doxegodpajvhrtnm")
    public suspend fun errorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorType = mapped
    }

    /**
     * @param value The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("iqjkrsdcaqeiqvid")
    public suspend fun innerHealthErrors(`value`: List<InnerHealthErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.innerHealthErrors = mapped
    }

    /**
     * @param argument The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("lemwmbngyvttstav")
    public suspend fun innerHealthErrors(argument: List<suspend InnerHealthErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InnerHealthErrorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.innerHealthErrors = mapped
    }

    /**
     * @param argument The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("ugvwsppppkjelucg")
    public suspend fun innerHealthErrors(vararg argument: suspend InnerHealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InnerHealthErrorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.innerHealthErrors = mapped
    }

    /**
     * @param argument The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("ptuxxwvauqjjxpli")
    public suspend fun innerHealthErrors(argument: suspend InnerHealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InnerHealthErrorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.innerHealthErrors = mapped
    }

    /**
     * @param values The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
     */
    @JvmName("uyqhilqeedtgamje")
    public suspend fun innerHealthErrors(vararg values: InnerHealthErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.innerHealthErrors = mapped
    }

    /**
     * @param value Possible causes of error.
     */
    @JvmName("mxgohwlusftwglon")
    public suspend fun possibleCauses(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.possibleCauses = mapped
    }

    /**
     * @param value Recommended action to resolve error.
     */
    @JvmName("nhqhalfsrahjdnwj")
    public suspend fun recommendedAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendedAction = mapped
    }

    /**
     * @param value DRA error message.
     */
    @JvmName("vtijotkrnbhopitp")
    public suspend fun recoveryProviderErrorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryProviderErrorMessage = mapped
    }

    /**
     * @param value Summary message of the entity.
     */
    @JvmName("hhnkoblfnrpxufyt")
    public suspend fun summaryMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summaryMessage = mapped
    }

    internal fun build(): HealthErrorArgs = HealthErrorArgs(
        creationTimeUtc = creationTimeUtc,
        customerResolvability = customerResolvability,
        entityId = entityId,
        errorCategory = errorCategory,
        errorCode = errorCode,
        errorId = errorId,
        errorLevel = errorLevel,
        errorMessage = errorMessage,
        errorSource = errorSource,
        errorType = errorType,
        innerHealthErrors = innerHealthErrors,
        possibleCauses = possibleCauses,
        recommendedAction = recommendedAction,
        recoveryProviderErrorMessage = recoveryProviderErrorMessage,
        summaryMessage = summaryMessage,
    )
}
