@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzureEnableProtectionInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DiskAccountType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.LicenseType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SqlServerLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HyperVReplicaAzure specific enable protection input.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskType The DiskType.
 * @property disksToInclude The list of VHD Ids of disks to be protected.
 * @property disksToIncludeForManagedDisks The disks to include list for managed disks.
 * @property enableRdpOnTargetOption The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
 * @property hvHostVmId The Hyper-V host VM Id.
 * @property instanceType The class type.
 * Expected value is 'HyperVReplicaAzure'.
 * @property licenseType License type.
 * @property logStorageAccountId The storage account to be used for logging during replication.
 * @property osType The OS type associated with VM.
 * @property seedManagedDiskTags The tags for the seed managed disks.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property targetAvailabilitySetId The target availability set ARM Id for resource manager deployment.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetAzureNetworkId The selected target Azure network Id.
 * @property targetAzureSubnetId The selected target Azure subnet Id.
 * @property targetAzureV1ResourceGroupId The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
 * @property targetAzureV2ResourceGroupId The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
 * @property targetAzureVmName The target azure VM Name.
 * @property targetManagedDiskTags The tags for the target managed disks.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The proximity placement group ARM Id.
 * @property targetStorageAccountId The storage account Id.
 * @property targetVmSize The target VM size.
 * @property targetVmTags The target VM tags.
 * @property useManagedDisks A value indicating whether managed disks should be used during failover.
 * @property useManagedDisksForReplication A value indicating whether managed disks should be used during replication.
 * @property vhdId The OS disk VHD id associated with VM.
 * @property vmName The VM Name.
 */
public data class HyperVReplicaAzureEnableProtectionInputArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskType: Output<Either<String, DiskAccountType>>? = null,
    public val disksToInclude: Output<List<String>>? = null,
    public val disksToIncludeForManagedDisks: Output<List<HyperVReplicaAzureDiskInputDetailsArgs>>? =
        null,
    public val enableRdpOnTargetOption: Output<String>? = null,
    public val hvHostVmId: Output<String>? = null,
    public val instanceType: Output<String>,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val logStorageAccountId: Output<String>? = null,
    public val osType: Output<String>? = null,
    public val seedManagedDiskTags: Output<Map<String, String>>? = null,
    public val sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null,
    public val targetAvailabilitySetId: Output<String>? = null,
    public val targetAvailabilityZone: Output<String>? = null,
    public val targetAzureNetworkId: Output<String>? = null,
    public val targetAzureSubnetId: Output<String>? = null,
    public val targetAzureV1ResourceGroupId: Output<String>? = null,
    public val targetAzureV2ResourceGroupId: Output<String>? = null,
    public val targetAzureVmName: Output<String>? = null,
    public val targetManagedDiskTags: Output<Map<String, String>>? = null,
    public val targetNicTags: Output<Map<String, String>>? = null,
    public val targetProximityPlacementGroupId: Output<String>? = null,
    public val targetStorageAccountId: Output<String>? = null,
    public val targetVmSize: Output<String>? = null,
    public val targetVmTags: Output<Map<String, String>>? = null,
    public val useManagedDisks: Output<String>? = null,
    public val useManagedDisksForReplication: Output<String>? = null,
    public val vhdId: Output<String>? = null,
    public val vmName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzureEnableProtectionInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzureEnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzureEnableProtectionInputArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disksToInclude(disksToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .disksToIncludeForManagedDisks(
                disksToIncludeForManagedDisks?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .enableRdpOnTargetOption(enableRdpOnTargetOption?.applyValue({ args0 -> args0 }))
            .hvHostVmId(hvHostVmId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logStorageAccountId(logStorageAccountId?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .seedManagedDiskTags(
                seedManagedDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sqlServerLicenseType(
                sqlServerLicenseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .targetAvailabilitySetId(targetAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .targetAvailabilityZone(targetAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetAzureNetworkId(targetAzureNetworkId?.applyValue({ args0 -> args0 }))
            .targetAzureSubnetId(targetAzureSubnetId?.applyValue({ args0 -> args0 }))
            .targetAzureV1ResourceGroupId(targetAzureV1ResourceGroupId?.applyValue({ args0 -> args0 }))
            .targetAzureV2ResourceGroupId(targetAzureV2ResourceGroupId?.applyValue({ args0 -> args0 }))
            .targetAzureVmName(targetAzureVmName?.applyValue({ args0 -> args0 }))
            .targetManagedDiskTags(
                targetManagedDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetNicTags(
                targetNicTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetProximityPlacementGroupId(targetProximityPlacementGroupId?.applyValue({ args0 -> args0 }))
            .targetStorageAccountId(targetStorageAccountId?.applyValue({ args0 -> args0 }))
            .targetVmSize(targetVmSize?.applyValue({ args0 -> args0 }))
            .targetVmTags(
                targetVmTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .useManagedDisks(useManagedDisks?.applyValue({ args0 -> args0 }))
            .useManagedDisksForReplication(useManagedDisksForReplication?.applyValue({ args0 -> args0 }))
            .vhdId(vhdId?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVReplicaAzureEnableProtectionInputArgs].
 */
@PulumiTagMarker
public class HyperVReplicaAzureEnableProtectionInputArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var diskType: Output<Either<String, DiskAccountType>>? = null

    private var disksToInclude: Output<List<String>>? = null

    private var disksToIncludeForManagedDisks: Output<List<HyperVReplicaAzureDiskInputDetailsArgs>>? =
        null

    private var enableRdpOnTargetOption: Output<String>? = null

    private var hvHostVmId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var logStorageAccountId: Output<String>? = null

    private var osType: Output<String>? = null

    private var seedManagedDiskTags: Output<Map<String, String>>? = null

    private var sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null

    private var targetAvailabilitySetId: Output<String>? = null

    private var targetAvailabilityZone: Output<String>? = null

    private var targetAzureNetworkId: Output<String>? = null

    private var targetAzureSubnetId: Output<String>? = null

    private var targetAzureV1ResourceGroupId: Output<String>? = null

    private var targetAzureV2ResourceGroupId: Output<String>? = null

    private var targetAzureVmName: Output<String>? = null

    private var targetManagedDiskTags: Output<Map<String, String>>? = null

    private var targetNicTags: Output<Map<String, String>>? = null

    private var targetProximityPlacementGroupId: Output<String>? = null

    private var targetStorageAccountId: Output<String>? = null

    private var targetVmSize: Output<String>? = null

    private var targetVmTags: Output<Map<String, String>>? = null

    private var useManagedDisks: Output<String>? = null

    private var useManagedDisksForReplication: Output<String>? = null

    private var vhdId: Output<String>? = null

    private var vmName: Output<String>? = null

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("xxivxtawryfhelsf")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("twtunldtpdccalsh")
    public suspend fun diskType(`value`: Output<Either<String, DiskAccountType>>) {
        this.diskType = value
    }

    /**
     * @param value The list of VHD Ids of disks to be protected.
     */
    @JvmName("tgfdsjutyodaudge")
    public suspend fun disksToInclude(`value`: Output<List<String>>) {
        this.disksToInclude = value
    }

    @JvmName("hnydvycnyeehkhmk")
    public suspend fun disksToInclude(vararg values: Output<String>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values The list of VHD Ids of disks to be protected.
     */
    @JvmName("shikqbolkfieddpu")
    public suspend fun disksToInclude(values: List<Output<String>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value The disks to include list for managed disks.
     */
    @JvmName("hfkexxfhhoggplmv")
    public suspend fun disksToIncludeForManagedDisks(`value`: Output<List<HyperVReplicaAzureDiskInputDetailsArgs>>) {
        this.disksToIncludeForManagedDisks = value
    }

    @JvmName("fplwgcympxmjyuqd")
    public suspend fun disksToIncludeForManagedDisks(vararg values: Output<HyperVReplicaAzureDiskInputDetailsArgs>) {
        this.disksToIncludeForManagedDisks = Output.all(values.asList())
    }

    /**
     * @param values The disks to include list for managed disks.
     */
    @JvmName("tfifwayrbvjmnaom")
    public suspend fun disksToIncludeForManagedDisks(values: List<Output<HyperVReplicaAzureDiskInputDetailsArgs>>) {
        this.disksToIncludeForManagedDisks = Output.all(values)
    }

    /**
     * @param value The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
     */
    @JvmName("qxjvuagvonkkxxyo")
    public suspend fun enableRdpOnTargetOption(`value`: Output<String>) {
        this.enableRdpOnTargetOption = value
    }

    /**
     * @param value The Hyper-V host VM Id.
     */
    @JvmName("hernnwanvkxbeoal")
    public suspend fun hvHostVmId(`value`: Output<String>) {
        this.hvHostVmId = value
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplicaAzure'.
     */
    @JvmName("ukforclnewwtbscc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value License type.
     */
    @JvmName("cfpojeaumbqfdffc")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The storage account to be used for logging during replication.
     */
    @JvmName("eahkicifapkrlgkx")
    public suspend fun logStorageAccountId(`value`: Output<String>) {
        this.logStorageAccountId = value
    }

    /**
     * @param value The OS type associated with VM.
     */
    @JvmName("ypstotlynoxugonr")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The tags for the seed managed disks.
     */
    @JvmName("qvljxlloyugqqjgl")
    public suspend fun seedManagedDiskTags(`value`: Output<Map<String, String>>) {
        this.seedManagedDiskTags = value
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("gknykbsflijrhrir")
    public suspend fun sqlServerLicenseType(`value`: Output<Either<String, SqlServerLicenseType>>) {
        this.sqlServerLicenseType = value
    }

    /**
     * @param value The target availability set ARM Id for resource manager deployment.
     */
    @JvmName("rmxvoeltopvojjsl")
    public suspend fun targetAvailabilitySetId(`value`: Output<String>) {
        this.targetAvailabilitySetId = value
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("ysmuokvmbeuedjqs")
    public suspend fun targetAvailabilityZone(`value`: Output<String>) {
        this.targetAvailabilityZone = value
    }

    /**
     * @param value The selected target Azure network Id.
     */
    @JvmName("bhahcmbkulnloelq")
    public suspend fun targetAzureNetworkId(`value`: Output<String>) {
        this.targetAzureNetworkId = value
    }

    /**
     * @param value The selected target Azure subnet Id.
     */
    @JvmName("sveufdvtjtffyyaf")
    public suspend fun targetAzureSubnetId(`value`: Output<String>) {
        this.targetAzureSubnetId = value
    }

    /**
     * @param value The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
     */
    @JvmName("xhabyogpgxcouwgp")
    public suspend fun targetAzureV1ResourceGroupId(`value`: Output<String>) {
        this.targetAzureV1ResourceGroupId = value
    }

    /**
     * @param value The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
     */
    @JvmName("mqjdawtjutunvbcp")
    public suspend fun targetAzureV2ResourceGroupId(`value`: Output<String>) {
        this.targetAzureV2ResourceGroupId = value
    }

    /**
     * @param value The target azure VM Name.
     */
    @JvmName("lnaqumswnckhaclh")
    public suspend fun targetAzureVmName(`value`: Output<String>) {
        this.targetAzureVmName = value
    }

    /**
     * @param value The tags for the target managed disks.
     */
    @JvmName("fmjiyuamtohdpqnb")
    public suspend fun targetManagedDiskTags(`value`: Output<Map<String, String>>) {
        this.targetManagedDiskTags = value
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("sqlubvfinfpohbqm")
    public suspend fun targetNicTags(`value`: Output<Map<String, String>>) {
        this.targetNicTags = value
    }

    /**
     * @param value The proximity placement group ARM Id.
     */
    @JvmName("wqlgjgcnplgukeqe")
    public suspend fun targetProximityPlacementGroupId(`value`: Output<String>) {
        this.targetProximityPlacementGroupId = value
    }

    /**
     * @param value The storage account Id.
     */
    @JvmName("ruchdcigachinlti")
    public suspend fun targetStorageAccountId(`value`: Output<String>) {
        this.targetStorageAccountId = value
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("ecssnbgokologdtx")
    public suspend fun targetVmSize(`value`: Output<String>) {
        this.targetVmSize = value
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("jxhwojttdwyxunwg")
    public suspend fun targetVmTags(`value`: Output<Map<String, String>>) {
        this.targetVmTags = value
    }

    /**
     * @param value A value indicating whether managed disks should be used during failover.
     */
    @JvmName("qutttyqtchsypvsi")
    public suspend fun useManagedDisks(`value`: Output<String>) {
        this.useManagedDisks = value
    }

    /**
     * @param value A value indicating whether managed disks should be used during replication.
     */
    @JvmName("ukpoinutadlvyojt")
    public suspend fun useManagedDisksForReplication(`value`: Output<String>) {
        this.useManagedDisksForReplication = value
    }

    /**
     * @param value The OS disk VHD id associated with VM.
     */
    @JvmName("utqrggslpjmpfgya")
    public suspend fun vhdId(`value`: Output<String>) {
        this.vhdId = value
    }

    /**
     * @param value The VM Name.
     */
    @JvmName("sxnvpvgqeuxtjvch")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("ihqvvciblihgojvd")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("lqwlumibqoplnjob")
    public suspend fun diskType(`value`: Either<String, DiskAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("lltgxpxrfepigntr")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("euanjouvkkadyasy")
    public fun diskType(`value`: DiskAccountType) {
        val toBeMapped = Either.ofRight<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The list of VHD Ids of disks to be protected.
     */
    @JvmName("vvyedyrdydctmbiy")
    public suspend fun disksToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param values The list of VHD Ids of disks to be protected.
     */
    @JvmName("tvelspngmhrhelpr")
    public suspend fun disksToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value The disks to include list for managed disks.
     */
    @JvmName("mojrxyqlykfisbgn")
    public suspend fun disksToIncludeForManagedDisks(`value`: List<HyperVReplicaAzureDiskInputDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksToIncludeForManagedDisks = mapped
    }

    /**
     * @param argument The disks to include list for managed disks.
     */
    @JvmName("xvcbksrgesaghpeq")
    public suspend fun disksToIncludeForManagedDisks(argument: List<suspend HyperVReplicaAzureDiskInputDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HyperVReplicaAzureDiskInputDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToIncludeForManagedDisks = mapped
    }

    /**
     * @param argument The disks to include list for managed disks.
     */
    @JvmName("roekpfhbesriirio")
    public suspend fun disksToIncludeForManagedDisks(vararg argument: suspend HyperVReplicaAzureDiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HyperVReplicaAzureDiskInputDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToIncludeForManagedDisks = mapped
    }

    /**
     * @param argument The disks to include list for managed disks.
     */
    @JvmName("lhdhkuldsncugcdp")
    public suspend fun disksToIncludeForManagedDisks(argument: suspend HyperVReplicaAzureDiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HyperVReplicaAzureDiskInputDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.disksToIncludeForManagedDisks = mapped
    }

    /**
     * @param values The disks to include list for managed disks.
     */
    @JvmName("wwcklvkwsvivustg")
    public suspend fun disksToIncludeForManagedDisks(vararg values: HyperVReplicaAzureDiskInputDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToIncludeForManagedDisks = mapped
    }

    /**
     * @param value The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
     */
    @JvmName("sqbawsvrkqbfbwyt")
    public suspend fun enableRdpOnTargetOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRdpOnTargetOption = mapped
    }

    /**
     * @param value The Hyper-V host VM Id.
     */
    @JvmName("gkakwjkuurpklexk")
    public suspend fun hvHostVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hvHostVmId = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplicaAzure'.
     */
    @JvmName("gxxerlosjdagssjm")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("jclnnbdnegntpwpc")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("vnkexjlbubddljje")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("ywcegvwxotgajrlb")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The storage account to be used for logging during replication.
     */
    @JvmName("efywxbgfkucaodwt")
    public suspend fun logStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorageAccountId = mapped
    }

    /**
     * @param value The OS type associated with VM.
     */
    @JvmName("cxihewdsdeoxsxdu")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The tags for the seed managed disks.
     */
    @JvmName("jgmehawnoqqsryvp")
    public suspend fun seedManagedDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seedManagedDiskTags = mapped
    }

    /**
     * @param values The tags for the seed managed disks.
     */
    @JvmName("gokikjcrqsqepsym")
    public fun seedManagedDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seedManagedDiskTags = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("pbqyybumpcfomask")
    public suspend fun sqlServerLicenseType(`value`: Either<String, SqlServerLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("xdipgwulxnocvjlf")
    public fun sqlServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("bsgxmoiboiesliqp")
    public fun sqlServerLicenseType(`value`: SqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The target availability set ARM Id for resource manager deployment.
     */
    @JvmName("gpwvfxapvcxbhmlu")
    public suspend fun targetAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilitySetId = mapped
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("yerndvrxihmbevgr")
    public suspend fun targetAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value The selected target Azure network Id.
     */
    @JvmName("kiowrnkvnlefdfgb")
    public suspend fun targetAzureNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureNetworkId = mapped
    }

    /**
     * @param value The selected target Azure subnet Id.
     */
    @JvmName("omqtrguqipocqwsf")
    public suspend fun targetAzureSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureSubnetId = mapped
    }

    /**
     * @param value The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
     */
    @JvmName("eutfbigfmktdvhiu")
    public suspend fun targetAzureV1ResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureV1ResourceGroupId = mapped
    }

    /**
     * @param value The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
     */
    @JvmName("joeuxaavqovtnjpg")
    public suspend fun targetAzureV2ResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureV2ResourceGroupId = mapped
    }

    /**
     * @param value The target azure VM Name.
     */
    @JvmName("dwftrbykcdvhmsxl")
    public suspend fun targetAzureVmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureVmName = mapped
    }

    /**
     * @param value The tags for the target managed disks.
     */
    @JvmName("hmtndivumxdpsrbp")
    public suspend fun targetManagedDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetManagedDiskTags = mapped
    }

    /**
     * @param values The tags for the target managed disks.
     */
    @JvmName("eujgyawnbtlywuev")
    public fun targetManagedDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetManagedDiskTags = mapped
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("lqelrirorwcmrndw")
    public suspend fun targetNicTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param values The tags for the target NICs.
     */
    @JvmName("dqsycydqfoacfikb")
    public fun targetNicTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param value The proximity placement group ARM Id.
     */
    @JvmName("wnkgrfdlsclnnpwg")
    public suspend fun targetProximityPlacementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProximityPlacementGroupId = mapped
    }

    /**
     * @param value The storage account Id.
     */
    @JvmName("xsnrfbqhpldswqll")
    public suspend fun targetStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetStorageAccountId = mapped
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("wfvhweycxijqvofk")
    public suspend fun targetVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSize = mapped
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("fmkvrxqtqcthqtbb")
    public suspend fun targetVmTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    /**
     * @param values The target VM tags.
     */
    @JvmName("aaekbnxpfldftrqk")
    public fun targetVmTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    /**
     * @param value A value indicating whether managed disks should be used during failover.
     */
    @JvmName("xrtcxfcugdxybygc")
    public suspend fun useManagedDisks(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useManagedDisks = mapped
    }

    /**
     * @param value A value indicating whether managed disks should be used during replication.
     */
    @JvmName("xgvjsihdrkvbhlty")
    public suspend fun useManagedDisksForReplication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useManagedDisksForReplication = mapped
    }

    /**
     * @param value The OS disk VHD id associated with VM.
     */
    @JvmName("gwbrrpxhirvqkmsq")
    public suspend fun vhdId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdId = mapped
    }

    /**
     * @param value The VM Name.
     */
    @JvmName("oyopqqtqxtewcsjg")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    internal fun build(): HyperVReplicaAzureEnableProtectionInputArgs =
        HyperVReplicaAzureEnableProtectionInputArgs(
            diskEncryptionSetId = diskEncryptionSetId,
            diskType = diskType,
            disksToInclude = disksToInclude,
            disksToIncludeForManagedDisks = disksToIncludeForManagedDisks,
            enableRdpOnTargetOption = enableRdpOnTargetOption,
            hvHostVmId = hvHostVmId,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            licenseType = licenseType,
            logStorageAccountId = logStorageAccountId,
            osType = osType,
            seedManagedDiskTags = seedManagedDiskTags,
            sqlServerLicenseType = sqlServerLicenseType,
            targetAvailabilitySetId = targetAvailabilitySetId,
            targetAvailabilityZone = targetAvailabilityZone,
            targetAzureNetworkId = targetAzureNetworkId,
            targetAzureSubnetId = targetAzureSubnetId,
            targetAzureV1ResourceGroupId = targetAzureV1ResourceGroupId,
            targetAzureV2ResourceGroupId = targetAzureV2ResourceGroupId,
            targetAzureVmName = targetAzureVmName,
            targetManagedDiskTags = targetManagedDiskTags,
            targetNicTags = targetNicTags,
            targetProximityPlacementGroupId = targetProximityPlacementGroupId,
            targetStorageAccountId = targetStorageAccountId,
            targetVmSize = targetVmSize,
            targetVmTags = targetVmTags,
            useManagedDisks = useManagedDisks,
            useManagedDisksForReplication = useManagedDisksForReplication,
            vhdId = vhdId,
            vmName = vmName,
        )
}
