@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageDiskSignatureExclusionOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.
 * @property diskSignature The guest signature of disk to be excluded from replication.
 */
public data class InMageDiskSignatureExclusionOptionsArgs(
    public val diskSignature: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageDiskSignatureExclusionOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InMageDiskSignatureExclusionOptionsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageDiskSignatureExclusionOptionsArgs.builder()
            .diskSignature(diskSignature?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageDiskSignatureExclusionOptionsArgs].
 */
@PulumiTagMarker
public class InMageDiskSignatureExclusionOptionsArgsBuilder internal constructor() {
    private var diskSignature: Output<String>? = null

    /**
     * @param value The guest signature of disk to be excluded from replication.
     */
    @JvmName("cqmyhfwisgdptwnl")
    public suspend fun diskSignature(`value`: Output<String>) {
        this.diskSignature = value
    }

    /**
     * @param value The guest signature of disk to be excluded from replication.
     */
    @JvmName("ifxywwjiatsnkiad")
    public suspend fun diskSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSignature = mapped
    }

    internal fun build(): InMageDiskSignatureExclusionOptionsArgs =
        InMageDiskSignatureExclusionOptionsArgs(
            diskSignature = diskSignature,
        )
}
