@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageRcmDiskInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DiskAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * InMageRcm disk input.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskId The disk Id.
 * @property diskType The disk type.
 * @property logStorageAccountId The log storage account ARM Id.
 */
public data class InMageRcmDiskInputArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskId: Output<String>,
    public val diskType: Output<Either<String, DiskAccountType>>,
    public val logStorageAccountId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageRcmDiskInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InMageRcmDiskInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmDiskInputArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskId(diskId.applyValue({ args0 -> args0 }))
            .diskType(
                diskType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logStorageAccountId(logStorageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageRcmDiskInputArgs].
 */
@PulumiTagMarker
public class InMageRcmDiskInputArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var diskId: Output<String>? = null

    private var diskType: Output<Either<String, DiskAccountType>>? = null

    private var logStorageAccountId: Output<String>? = null

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("tvnvhfgpwwilrorc")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("vjhmlnimdhvlexbu")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The disk type.
     */
    @JvmName("cyumirupuxypnlkt")
    public suspend fun diskType(`value`: Output<Either<String, DiskAccountType>>) {
        this.diskType = value
    }

    /**
     * @param value The log storage account ARM Id.
     */
    @JvmName("nuuqehjrovgotcpw")
    public suspend fun logStorageAccountId(`value`: Output<String>) {
        this.logStorageAccountId = value
    }

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("jvikmtfbclsrklbn")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("mvxkvsdubhbsmwsx")
    public suspend fun diskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("kvunbjawppbvcuer")
    public suspend fun diskType(`value`: Either<String, DiskAccountType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("ymrbqxmnrcisoypd")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("sceueplpaixrajoi")
    public fun diskType(`value`: DiskAccountType) {
        val toBeMapped = Either.ofRight<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The log storage account ARM Id.
     */
    @JvmName("ktthntgwoxxixfmk")
    public suspend fun logStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStorageAccountId = mapped
    }

    internal fun build(): InMageRcmDiskInputArgs = InMageRcmDiskInputArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        diskId = diskId ?: throw PulumiNullFieldException("diskId"),
        diskType = diskType ?: throw PulumiNullFieldException("diskType"),
        logStorageAccountId = logStorageAccountId ?: throw PulumiNullFieldException("logStorageAccountId"),
    )
}
