@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InnerHealthErrorArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.HealthErrorCustomerResolvability
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
 * @property creationTimeUtc Error creation time (UTC).
 * @property customerResolvability Value indicating whether the health error is customer resolvable.
 * @property entityId ID of the entity.
 * @property errorCategory Category of error.
 * @property errorCode Error code.
 * @property errorId The health error unique id.
 * @property errorLevel Level of error.
 * @property errorMessage Error message.
 * @property errorSource Source of error.
 * @property errorType Type of error.
 * @property possibleCauses Possible causes of error.
 * @property recommendedAction Recommended action to resolve error.
 * @property recoveryProviderErrorMessage DRA error message.
 * @property summaryMessage Summary message of the entity.
 */
public data class InnerHealthErrorArgs(
    public val creationTimeUtc: Output<String>? = null,
    public val customerResolvability: Output<Either<String, HealthErrorCustomerResolvability>>? =
        null,
    public val entityId: Output<String>? = null,
    public val errorCategory: Output<String>? = null,
    public val errorCode: Output<String>? = null,
    public val errorId: Output<String>? = null,
    public val errorLevel: Output<String>? = null,
    public val errorMessage: Output<String>? = null,
    public val errorSource: Output<String>? = null,
    public val errorType: Output<String>? = null,
    public val possibleCauses: Output<String>? = null,
    public val recommendedAction: Output<String>? = null,
    public val recoveryProviderErrorMessage: Output<String>? = null,
    public val summaryMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InnerHealthErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InnerHealthErrorArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InnerHealthErrorArgs.builder()
            .creationTimeUtc(creationTimeUtc?.applyValue({ args0 -> args0 }))
            .customerResolvability(
                customerResolvability?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .entityId(entityId?.applyValue({ args0 -> args0 }))
            .errorCategory(errorCategory?.applyValue({ args0 -> args0 }))
            .errorCode(errorCode?.applyValue({ args0 -> args0 }))
            .errorId(errorId?.applyValue({ args0 -> args0 }))
            .errorLevel(errorLevel?.applyValue({ args0 -> args0 }))
            .errorMessage(errorMessage?.applyValue({ args0 -> args0 }))
            .errorSource(errorSource?.applyValue({ args0 -> args0 }))
            .errorType(errorType?.applyValue({ args0 -> args0 }))
            .possibleCauses(possibleCauses?.applyValue({ args0 -> args0 }))
            .recommendedAction(recommendedAction?.applyValue({ args0 -> args0 }))
            .recoveryProviderErrorMessage(recoveryProviderErrorMessage?.applyValue({ args0 -> args0 }))
            .summaryMessage(summaryMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InnerHealthErrorArgs].
 */
@PulumiTagMarker
public class InnerHealthErrorArgsBuilder internal constructor() {
    private var creationTimeUtc: Output<String>? = null

    private var customerResolvability: Output<Either<String, HealthErrorCustomerResolvability>>? =
        null

    private var entityId: Output<String>? = null

    private var errorCategory: Output<String>? = null

    private var errorCode: Output<String>? = null

    private var errorId: Output<String>? = null

    private var errorLevel: Output<String>? = null

    private var errorMessage: Output<String>? = null

    private var errorSource: Output<String>? = null

    private var errorType: Output<String>? = null

    private var possibleCauses: Output<String>? = null

    private var recommendedAction: Output<String>? = null

    private var recoveryProviderErrorMessage: Output<String>? = null

    private var summaryMessage: Output<String>? = null

    /**
     * @param value Error creation time (UTC).
     */
    @JvmName("qcgnejhoepnqpyky")
    public suspend fun creationTimeUtc(`value`: Output<String>) {
        this.creationTimeUtc = value
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("jrgdfslglsktesrw")
    public suspend fun customerResolvability(`value`: Output<Either<String, HealthErrorCustomerResolvability>>) {
        this.customerResolvability = value
    }

    /**
     * @param value ID of the entity.
     */
    @JvmName("dhtrugyuhyjrptdo")
    public suspend fun entityId(`value`: Output<String>) {
        this.entityId = value
    }

    /**
     * @param value Category of error.
     */
    @JvmName("hfklysjygkimhaci")
    public suspend fun errorCategory(`value`: Output<String>) {
        this.errorCategory = value
    }

    /**
     * @param value Error code.
     */
    @JvmName("koretwhhgwjliuih")
    public suspend fun errorCode(`value`: Output<String>) {
        this.errorCode = value
    }

    /**
     * @param value The health error unique id.
     */
    @JvmName("uwiybtitqaqvffgr")
    public suspend fun errorId(`value`: Output<String>) {
        this.errorId = value
    }

    /**
     * @param value Level of error.
     */
    @JvmName("ltdbobsybywlbomh")
    public suspend fun errorLevel(`value`: Output<String>) {
        this.errorLevel = value
    }

    /**
     * @param value Error message.
     */
    @JvmName("sfgflbskhbhgxkfs")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Source of error.
     */
    @JvmName("rdjkqrchtysrpjmw")
    public suspend fun errorSource(`value`: Output<String>) {
        this.errorSource = value
    }

    /**
     * @param value Type of error.
     */
    @JvmName("yxfldwwfdnaqftaw")
    public suspend fun errorType(`value`: Output<String>) {
        this.errorType = value
    }

    /**
     * @param value Possible causes of error.
     */
    @JvmName("wujpbehriymssjyr")
    public suspend fun possibleCauses(`value`: Output<String>) {
        this.possibleCauses = value
    }

    /**
     * @param value Recommended action to resolve error.
     */
    @JvmName("bbkbuyfjjjflqere")
    public suspend fun recommendedAction(`value`: Output<String>) {
        this.recommendedAction = value
    }

    /**
     * @param value DRA error message.
     */
    @JvmName("lftaeiaokgflimdr")
    public suspend fun recoveryProviderErrorMessage(`value`: Output<String>) {
        this.recoveryProviderErrorMessage = value
    }

    /**
     * @param value Summary message of the entity.
     */
    @JvmName("eflekeyoivmvwuap")
    public suspend fun summaryMessage(`value`: Output<String>) {
        this.summaryMessage = value
    }

    /**
     * @param value Error creation time (UTC).
     */
    @JvmName("ereyxgpxunhhvegm")
    public suspend fun creationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationTimeUtc = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("choowlddaasouuxu")
    public suspend fun customerResolvability(`value`: Either<String, HealthErrorCustomerResolvability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("bylgeebhdwgjarxx")
    public fun customerResolvability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HealthErrorCustomerResolvability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value Value indicating whether the health error is customer resolvable.
     */
    @JvmName("tyklycbyketgmabk")
    public fun customerResolvability(`value`: HealthErrorCustomerResolvability) {
        val toBeMapped = Either.ofRight<String, HealthErrorCustomerResolvability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerResolvability = mapped
    }

    /**
     * @param value ID of the entity.
     */
    @JvmName("tikvnonruspqbnsu")
    public suspend fun entityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityId = mapped
    }

    /**
     * @param value Category of error.
     */
    @JvmName("brtbqejynnjdried")
    public suspend fun errorCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCategory = mapped
    }

    /**
     * @param value Error code.
     */
    @JvmName("wjnfdbcstynntmca")
    public suspend fun errorCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value The health error unique id.
     */
    @JvmName("wenlmugfudxjsrtx")
    public suspend fun errorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorId = mapped
    }

    /**
     * @param value Level of error.
     */
    @JvmName("niapvxckibqdggul")
    public suspend fun errorLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorLevel = mapped
    }

    /**
     * @param value Error message.
     */
    @JvmName("jhvhlmyunqepjcxo")
    public suspend fun errorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    /**
     * @param value Source of error.
     */
    @JvmName("qibidwdplferftuj")
    public suspend fun errorSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorSource = mapped
    }

    /**
     * @param value Type of error.
     */
    @JvmName("yvcrgosvgmvaaebh")
    public suspend fun errorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorType = mapped
    }

    /**
     * @param value Possible causes of error.
     */
    @JvmName("anfgblsuhqjetqpf")
    public suspend fun possibleCauses(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.possibleCauses = mapped
    }

    /**
     * @param value Recommended action to resolve error.
     */
    @JvmName("pvlqguyffnpnfuyv")
    public suspend fun recommendedAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendedAction = mapped
    }

    /**
     * @param value DRA error message.
     */
    @JvmName("ydtoxqshwqqcsqga")
    public suspend fun recoveryProviderErrorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryProviderErrorMessage = mapped
    }

    /**
     * @param value Summary message of the entity.
     */
    @JvmName("ivatakohoekctoag")
    public suspend fun summaryMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summaryMessage = mapped
    }

    internal fun build(): InnerHealthErrorArgs = InnerHealthErrorArgs(
        creationTimeUtc = creationTimeUtc,
        customerResolvability = customerResolvability,
        entityId = entityId,
        errorCategory = errorCategory,
        errorCode = errorCode,
        errorId = errorId,
        errorLevel = errorLevel,
        errorMessage = errorMessage,
        errorSource = errorSource,
        errorType = errorType,
        possibleCauses = possibleCauses,
        recommendedAction = recommendedAction,
        recoveryProviderErrorMessage = recoveryProviderErrorMessage,
        summaryMessage = summaryMessage,
    )
}
