@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MabContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container with items backed up using MAB backup engine.
 * @property agentVersion Agent version of this container.
 * @property backupManagementType Type of backup management for the container.
 * @property canReRegister Can the container be registered one more time.
 * @property containerHealthState Health state of mab container.
 * @property containerId ContainerID represents the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'Windows'.
 * @property extendedInfo Additional information for this container
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property mabContainerHealthDetails Health details on this mab container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of items backed up in this container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 */
public data class MabContainerArgs(
    public val agentVersion: Output<String>? = null,
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val canReRegister: Output<Boolean>? = null,
    public val containerHealthState: Output<String>? = null,
    public val containerId: Output<Double>? = null,
    public val containerType: Output<String>,
    public val extendedInfo: Output<MabContainerExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val mabContainerHealthDetails: Output<List<MABContainerHealthDetailsArgs>>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val protectedItemCount: Output<Double>? = null,
    public val registrationStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MabContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.MabContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MabContainerArgs.builder()
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 }))
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .canReRegister(canReRegister?.applyValue({ args0 -> args0 }))
            .containerHealthState(containerHealthState?.applyValue({ args0 -> args0 }))
            .containerId(containerId?.applyValue({ args0 -> args0 }))
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .mabContainerHealthDetails(
                mabContainerHealthDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .protectedItemCount(protectedItemCount?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MabContainerArgs].
 */
@PulumiTagMarker
public class MabContainerArgsBuilder internal constructor() {
    private var agentVersion: Output<String>? = null

    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var canReRegister: Output<Boolean>? = null

    private var containerHealthState: Output<String>? = null

    private var containerId: Output<Double>? = null

    private var containerType: Output<String>? = null

    private var extendedInfo: Output<MabContainerExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var mabContainerHealthDetails: Output<List<MABContainerHealthDetailsArgs>>? = null

    private var protectableObjectType: Output<String>? = null

    private var protectedItemCount: Output<Double>? = null

    private var registrationStatus: Output<String>? = null

    /**
     * @param value Agent version of this container.
     */
    @JvmName("lhfitavwhthmxxsg")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("uamwsewhfwpwohmu")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Can the container be registered one more time.
     */
    @JvmName("euhoapxxnunulidm")
    public suspend fun canReRegister(`value`: Output<Boolean>) {
        this.canReRegister = value
    }

    /**
     * @param value Health state of mab container.
     */
    @JvmName("sgcpsrikqyhygulo")
    public suspend fun containerHealthState(`value`: Output<String>) {
        this.containerHealthState = value
    }

    /**
     * @param value ContainerID represents the container.
     */
    @JvmName("xbcasdrwxgpfxyek")
    public suspend fun containerId(`value`: Output<Double>) {
        this.containerId = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'Windows'.
     */
    @JvmName("maagvwvxsmvaiudu")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Additional information for this container
     */
    @JvmName("owierigmeubiqese")
    public suspend fun extendedInfo(`value`: Output<MabContainerExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("hwvhsqmflatupyuq")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("vtsadvmcgxrkdfjc")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Health details on this mab container.
     */
    @JvmName("orwmnfibwhpidqtn")
    public suspend fun mabContainerHealthDetails(`value`: Output<List<MABContainerHealthDetailsArgs>>) {
        this.mabContainerHealthDetails = value
    }

    @JvmName("xixdamexdrhjktrj")
    public suspend fun mabContainerHealthDetails(vararg values: Output<MABContainerHealthDetailsArgs>) {
        this.mabContainerHealthDetails = Output.all(values.asList())
    }

    /**
     * @param values Health details on this mab container.
     */
    @JvmName("mewgnvwubkiwsbuo")
    public suspend fun mabContainerHealthDetails(values: List<Output<MABContainerHealthDetailsArgs>>) {
        this.mabContainerHealthDetails = Output.all(values)
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("dnrdlbfhpghyvmuf")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Number of items backed up in this container.
     */
    @JvmName("avkitbbfoqhahnke")
    public suspend fun protectedItemCount(`value`: Output<Double>) {
        this.protectedItemCount = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("jreaiqieyhufhiuj")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value Agent version of this container.
     */
    @JvmName("faxjwuucprnhgahg")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("audonwynsanaplco")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("nuktsyoluoueclyg")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("sjmvkjmwmlejnagq")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Can the container be registered one more time.
     */
    @JvmName("fnvolrvwncodrest")
    public suspend fun canReRegister(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canReRegister = mapped
    }

    /**
     * @param value Health state of mab container.
     */
    @JvmName("wvxoqyxfspfkpdxs")
    public suspend fun containerHealthState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerHealthState = mapped
    }

    /**
     * @param value ContainerID represents the container.
     */
    @JvmName("tktpijvgoufjkaws")
    public suspend fun containerId(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerId = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'Windows'.
     */
    @JvmName("atwqfjpukhndsnaa")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Additional information for this container
     */
    @JvmName("ewlloaojxglufict")
    public suspend fun extendedInfo(`value`: MabContainerExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional information for this container
     */
    @JvmName("dlsbnigamescmyok")
    public suspend fun extendedInfo(argument: suspend MabContainerExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MabContainerExtendedInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("phawdkacjakqvayq")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("bxsacmtaxlbvovof")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Health details on this mab container.
     */
    @JvmName("ulnibxpbygvvlvsg")
    public suspend fun mabContainerHealthDetails(`value`: List<MABContainerHealthDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mabContainerHealthDetails = mapped
    }

    /**
     * @param argument Health details on this mab container.
     */
    @JvmName("ndotvmwbukhompdw")
    public suspend fun mabContainerHealthDetails(argument: List<suspend MABContainerHealthDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MABContainerHealthDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mabContainerHealthDetails = mapped
    }

    /**
     * @param argument Health details on this mab container.
     */
    @JvmName("kwwtqgolsrokmyak")
    public suspend fun mabContainerHealthDetails(vararg argument: suspend MABContainerHealthDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MABContainerHealthDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mabContainerHealthDetails = mapped
    }

    /**
     * @param argument Health details on this mab container.
     */
    @JvmName("humbrrhsgnmvauxc")
    public suspend fun mabContainerHealthDetails(argument: suspend MABContainerHealthDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MABContainerHealthDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mabContainerHealthDetails = mapped
    }

    /**
     * @param values Health details on this mab container.
     */
    @JvmName("gthrsxphjyghibxi")
    public suspend fun mabContainerHealthDetails(vararg values: MABContainerHealthDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mabContainerHealthDetails = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("dtcwnjduspljvnmb")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Number of items backed up in this container.
     */
    @JvmName("gauqmbmcbjacbrnf")
    public suspend fun protectedItemCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemCount = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("enwswbdxutxbtgdc")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    internal fun build(): MabContainerArgs = MabContainerArgs(
        agentVersion = agentVersion,
        backupManagementType = backupManagementType,
        canReRegister = canReRegister,
        containerHealthState = containerHealthState,
        containerId = containerId,
        containerType = containerType ?: throw PulumiNullFieldException("containerType"),
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        healthStatus = healthStatus,
        mabContainerHealthDetails = mabContainerHealthDetails,
        protectableObjectType = protectableObjectType,
        protectedItemCount = protectedItemCount,
        registrationStatus = registrationStatus,
    )
}
