@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * MAB workload-specific backup item.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property computerName Name of the computer associated with this backup item.
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteSyncTimeInUTC Sync time for deferred deletion in UTC
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Additional information with this backup item.
 * @property friendlyName Friendly name of this backup item.
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property lastBackupStatus Status of last backup operation.
 * @property lastBackupTime Timestamp of the last backup operation on this backup item.
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemType backup item type.
 * Expected value is 'MabFileFolderProtectedItem'.
 * @property protectionState Protected, ProtectionStopped, IRPending or ProtectionError
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class MabFileFolderProtectedItemArgs(
    public val backupSetName: Output<String>? = null,
    public val computerName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteSyncTimeInUTC: Output<Double>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val extendedInfo: Output<MabFileFolderProtectedItemExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val lastBackupStatus: Output<String>? = null,
    public val lastBackupTime: Output<String>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<String>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemArgs.builder()
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteSyncTimeInUTC(deferredDeleteSyncTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .lastBackupStatus(lastBackupStatus?.applyValue({ args0 -> args0 }))
            .lastBackupTime(lastBackupTime?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(protectionState?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MabFileFolderProtectedItemArgs].
 */
@PulumiTagMarker
public class MabFileFolderProtectedItemArgsBuilder internal constructor() {
    private var backupSetName: Output<String>? = null

    private var computerName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteSyncTimeInUTC: Output<Double>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var extendedInfo: Output<MabFileFolderProtectedItemExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var lastBackupStatus: Output<String>? = null

    private var lastBackupTime: Output<String>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<String>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("kpwfemlgwvqajwxf")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Name of the computer associated with this backup item.
     */
    @JvmName("atscryowqebfoeiw")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("lbirbmywrjhffkgj")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("jpjeeirxesmuximf")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Sync time for deferred deletion in UTC
     */
    @JvmName("liinyktskjsraewv")
    public suspend fun deferredDeleteSyncTimeInUTC(`value`: Output<Double>) {
        this.deferredDeleteSyncTimeInUTC = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("bawalhfhrqptwvns")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("urckdohvdxunyfuu")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Additional information with this backup item.
     */
    @JvmName("hwobfaqutmmrpmtc")
    public suspend fun extendedInfo(`value`: Output<MabFileFolderProtectedItemExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of this backup item.
     */
    @JvmName("bkbfaepqynqieujt")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("pratkcdsvresgnkw")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("atmqkdkpyawnsnnx")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("cfhrtixfhhvikrto")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("xgrlcpahbliudrat")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Status of last backup operation.
     */
    @JvmName("nenoefvqqwnmsnei")
    public suspend fun lastBackupStatus(`value`: Output<String>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("rygujvaipejoobjx")
    public suspend fun lastBackupTime(`value`: Output<String>) {
        this.lastBackupTime = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("pausmxxpvifnnhhh")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("xhhjfbxsbnmbqyrp")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("ldnwpkeedcirxdtm")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'MabFileFolderProtectedItem'.
     */
    @JvmName("exkgomnopswqqmun")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Protected, ProtectionStopped, IRPending or ProtectionError
     */
    @JvmName("jhmatarmgqpveviw")
    public suspend fun protectionState(`value`: Output<String>) {
        this.protectionState = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("qejgkektactmqiid")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("watsbscgxnrfsmjv")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("mwvoatofgvkmtpfh")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("xxdvefqucrdsyadd")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("diinnbqxdrbwqism")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("unxxidmtrkhuxyoq")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Name of the computer associated with this backup item.
     */
    @JvmName("ujnlkanglpjeogwh")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("afyeoovkgdwawdci")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("yuspyfnxlxigghig")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("vxejdkeooglnyqvt")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("xobvdkrklorcifme")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Sync time for deferred deletion in UTC
     */
    @JvmName("botvxmqnvcjkymyr")
    public suspend fun deferredDeleteSyncTimeInUTC(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteSyncTimeInUTC = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("hcshfrsmsdkbmeyw")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("dcweojrcgxkliunl")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Additional information with this backup item.
     */
    @JvmName("giejorkiuyfewbet")
    public suspend fun extendedInfo(`value`: MabFileFolderProtectedItemExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional information with this backup item.
     */
    @JvmName("gceljykujnysojnp")
    public suspend fun extendedInfo(argument: suspend MabFileFolderProtectedItemExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MabFileFolderProtectedItemExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of this backup item.
     */
    @JvmName("aoxmhoiiakhbuaum")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("kphnikndjfdxhdco")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("wuoohkykqupyieth")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("qwvtymjmgvrvaobe")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("pykxuggbcdyqphmg")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Status of last backup operation.
     */
    @JvmName("kttviilepiwbvqbd")
    public suspend fun lastBackupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Timestamp of the last backup operation on this backup item.
     */
    @JvmName("mftlmpchaeaxvhrp")
    public suspend fun lastBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupTime = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("frpfsoytgrgilhpx")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("wjladpcsvgtsdqby")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("ddsqrjtnprsuohwg")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'MabFileFolderProtectedItem'.
     */
    @JvmName("tsmvvfpqxipamxff")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Protected, ProtectionStopped, IRPending or ProtectionError
     */
    @JvmName("jnkspmvgbwbmcgvc")
    public suspend fun protectionState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("hwntrhwftxpoidsx")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("alkvqgwjmsnxixlh")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("xlnyxhydyotlhlua")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("xsjouqyrydasuugc")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): MabFileFolderProtectedItemArgs = MabFileFolderProtectedItemArgs(
        backupSetName = backupSetName,
        computerName = computerName,
        containerName = containerName,
        createMode = createMode,
        deferredDeleteSyncTimeInUTC = deferredDeleteSyncTimeInUTC,
        deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
        deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        isArchiveEnabled = isArchiveEnabled,
        isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
        isRehydrate = isRehydrate,
        isScheduledForDeferredDelete = isScheduledForDeferredDelete,
        lastBackupStatus = lastBackupStatus,
        lastBackupTime = lastBackupTime,
        lastRecoveryPoint = lastRecoveryPoint,
        policyId = policyId,
        policyName = policyName,
        protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
        protectionState = protectionState,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        sourceResourceId = sourceResourceId,
    )
}
