@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanScriptActionDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.RecoveryPlanActionLocation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Recovery plan script action details.
 * @property fabricLocation The fabric location.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'ScriptActionDetails'.
 * @property path The script path.
 * @property timeout The script timeout.
 */
public data class RecoveryPlanScriptActionDetailsArgs(
    public val fabricLocation: Output<Either<String, RecoveryPlanActionLocation>>,
    public val instanceType: Output<String>,
    public val path: Output<String>,
    public val timeout: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanScriptActionDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanScriptActionDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanScriptActionDetailsArgs.builder()
            .fabricLocation(
                fabricLocation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecoveryPlanScriptActionDetailsArgs].
 */
@PulumiTagMarker
public class RecoveryPlanScriptActionDetailsArgsBuilder internal constructor() {
    private var fabricLocation: Output<Either<String, RecoveryPlanActionLocation>>? = null

    private var instanceType: Output<String>? = null

    private var path: Output<String>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value The fabric location.
     */
    @JvmName("keotkfemeshmqhdf")
    public suspend fun fabricLocation(`value`: Output<Either<String, RecoveryPlanActionLocation>>) {
        this.fabricLocation = value
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'ScriptActionDetails'.
     */
    @JvmName("janbbxaglsihocti")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The script path.
     */
    @JvmName("svivdhbxyqprgmbk")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The script timeout.
     */
    @JvmName("wxcmkleovcxfqwkn")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("fgfkaqujoawrvylt")
    public suspend fun fabricLocation(`value`: Either<String, RecoveryPlanActionLocation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("cqtyryyvnfkyhxoc")
    public fun fabricLocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecoveryPlanActionLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value The fabric location.
     */
    @JvmName("vhxfpkpstnafedyn")
    public fun fabricLocation(`value`: RecoveryPlanActionLocation) {
        val toBeMapped = Either.ofRight<String, RecoveryPlanActionLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricLocation = mapped
    }

    /**
     * @param value Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
     * Expected value is 'ScriptActionDetails'.
     */
    @JvmName("qhoxhwlbufglkofa")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The script path.
     */
    @JvmName("rqxrqbqkrojbmfua")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The script timeout.
     */
    @JvmName("mnegjqqlmpiopvfb")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): RecoveryPlanScriptActionDetailsArgs = RecoveryPlanScriptActionDetailsArgs(
        fabricLocation = fabricLocation ?: throw PulumiNullFieldException("fabricLocation"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        path = path ?: throw PulumiNullFieldException("path"),
        timeout = timeout,
    )
}
