@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RegisteredClusterNodesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Extended location of the resource.
 * @property biosId The BIOS ID.
 * @property clusterNodeFqdn The cluster node name.
 * @property isSharedDiskVirtualNode A value indicating whether this represents virtual entity hosting all the shared disks.
 * @property machineId The machine ID.
 */
public data class RegisteredClusterNodesArgs(
    public val biosId: Output<String>? = null,
    public val clusterNodeFqdn: Output<String>? = null,
    public val isSharedDiskVirtualNode: Output<Boolean>? = null,
    public val machineId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RegisteredClusterNodesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RegisteredClusterNodesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RegisteredClusterNodesArgs.builder()
            .biosId(biosId?.applyValue({ args0 -> args0 }))
            .clusterNodeFqdn(clusterNodeFqdn?.applyValue({ args0 -> args0 }))
            .isSharedDiskVirtualNode(isSharedDiskVirtualNode?.applyValue({ args0 -> args0 }))
            .machineId(machineId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegisteredClusterNodesArgs].
 */
@PulumiTagMarker
public class RegisteredClusterNodesArgsBuilder internal constructor() {
    private var biosId: Output<String>? = null

    private var clusterNodeFqdn: Output<String>? = null

    private var isSharedDiskVirtualNode: Output<Boolean>? = null

    private var machineId: Output<String>? = null

    /**
     * @param value The BIOS ID.
     */
    @JvmName("hhvlodccusduxrdh")
    public suspend fun biosId(`value`: Output<String>) {
        this.biosId = value
    }

    /**
     * @param value The cluster node name.
     */
    @JvmName("sqohwkotwrqdcnid")
    public suspend fun clusterNodeFqdn(`value`: Output<String>) {
        this.clusterNodeFqdn = value
    }

    /**
     * @param value A value indicating whether this represents virtual entity hosting all the shared disks.
     */
    @JvmName("iljskwmpsprptqmd")
    public suspend fun isSharedDiskVirtualNode(`value`: Output<Boolean>) {
        this.isSharedDiskVirtualNode = value
    }

    /**
     * @param value The machine ID.
     */
    @JvmName("fbqwhprfuprvfunu")
    public suspend fun machineId(`value`: Output<String>) {
        this.machineId = value
    }

    /**
     * @param value The BIOS ID.
     */
    @JvmName("hnhmekyytfxocuvs")
    public suspend fun biosId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.biosId = mapped
    }

    /**
     * @param value The cluster node name.
     */
    @JvmName("hfahnaoumiiwmeki")
    public suspend fun clusterNodeFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterNodeFqdn = mapped
    }

    /**
     * @param value A value indicating whether this represents virtual entity hosting all the shared disks.
     */
    @JvmName("xsxmpkxoxsfbsljp")
    public suspend fun isSharedDiskVirtualNode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSharedDiskVirtualNode = mapped
    }

    /**
     * @param value The machine ID.
     */
    @JvmName("tjrojjoxdmreanso")
    public suspend fun machineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineId = mapped
    }

    internal fun build(): RegisteredClusterNodesArgs = RegisteredClusterNodesArgs(
        biosId = biosId,
        clusterNodeFqdn = clusterNodeFqdn,
        isSharedDiskVirtualNode = isSharedDiskVirtualNode,
        machineId = machineId,
    )
}
