@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Replication protection cluster custom data details.
 * @property activeLocation The Current active location of the Protection cluster.
 * @property agentClusterId The Agent cluster Id.
 * @property allowedOperations The allowed operations on the Replication protection cluster.
 * @property areAllClusterNodesRegistered A value indicating whether all nodes of the cluster are registered or not.
 * @property clusterFqdn The cluster FQDN.
 * @property clusterNodeFqdns The List of cluster Node FQDNs.
 * @property clusterProtectedItemIds The List of Protected Item Id's.
 * @property clusterRegisteredNodes The registered node details.
 * @property currentScenario The current scenario.
 * @property healthErrors List of health errors.
 * @property lastSuccessfulFailoverTime The last successful failover time.
 * @property lastSuccessfulTestFailoverTime The last successful test failover time.
 * @property policyFriendlyName The name of Policy governing this PE.
 * @property policyId The Policy Id.
 * @property primaryFabricFriendlyName The friendly name of the primary fabric.
 * @property primaryFabricProvider The fabric provider of the primary fabric.
 * @property primaryProtectionContainerFriendlyName The name of primary protection container friendly name.
 * @property protectionClusterType The type of protection cluster type.
 * @property protectionState The protection status.
 * @property protectionStateDescription The protection state description.
 * @property providerSpecificDetails The Replication cluster provider custom settings.
 * @property recoveryContainerId The recovery container Id.
 * @property recoveryFabricFriendlyName The friendly name of recovery fabric.
 * @property recoveryFabricId The Arm Id of recovery fabric.
 * @property recoveryProtectionContainerFriendlyName The name of recovery container friendly name.
 * @property replicationHealth The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
 * @property sharedDiskProperties The shared disk properties.
 * @property testFailoverState The Test failover state.
 * @property testFailoverStateDescription The Test failover state description.
 */
public data class ReplicationProtectionClusterPropertiesArgs(
    public val activeLocation: Output<String>? = null,
    public val agentClusterId: Output<String>? = null,
    public val allowedOperations: Output<List<String>>? = null,
    public val areAllClusterNodesRegistered: Output<Boolean>? = null,
    public val clusterFqdn: Output<String>? = null,
    public val clusterNodeFqdns: Output<List<String>>? = null,
    public val clusterProtectedItemIds: Output<List<String>>? = null,
    public val clusterRegisteredNodes: Output<List<RegisteredClusterNodesArgs>>? = null,
    public val currentScenario: Output<CurrentScenarioDetailsArgs>? = null,
    public val healthErrors: Output<List<HealthErrorArgs>>? = null,
    public val lastSuccessfulFailoverTime: Output<String>? = null,
    public val lastSuccessfulTestFailoverTime: Output<String>? = null,
    public val policyFriendlyName: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val primaryFabricFriendlyName: Output<String>? = null,
    public val primaryFabricProvider: Output<String>? = null,
    public val primaryProtectionContainerFriendlyName: Output<String>? = null,
    public val protectionClusterType: Output<String>? = null,
    public val protectionState: Output<String>? = null,
    public val protectionStateDescription: Output<String>? = null,
    public val providerSpecificDetails: Output<A2AReplicationProtectionClusterDetailsArgs>? = null,
    public val recoveryContainerId: Output<String>? = null,
    public val recoveryFabricFriendlyName: Output<String>? = null,
    public val recoveryFabricId: Output<String>? = null,
    public val recoveryProtectionContainerFriendlyName: Output<String>? = null,
    public val replicationHealth: Output<String>? = null,
    public val sharedDiskProperties: Output<SharedDiskReplicationItemPropertiesArgs>? = null,
    public val testFailoverState: Output<String>? = null,
    public val testFailoverStateDescription: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs.builder()
            .activeLocation(activeLocation?.applyValue({ args0 -> args0 }))
            .agentClusterId(agentClusterId?.applyValue({ args0 -> args0 }))
            .allowedOperations(allowedOperations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .areAllClusterNodesRegistered(areAllClusterNodesRegistered?.applyValue({ args0 -> args0 }))
            .clusterFqdn(clusterFqdn?.applyValue({ args0 -> args0 }))
            .clusterNodeFqdns(clusterNodeFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterProtectedItemIds(
                clusterProtectedItemIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .clusterRegisteredNodes(
                clusterRegisteredNodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .currentScenario(currentScenario?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthErrors(
                healthErrors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lastSuccessfulFailoverTime(lastSuccessfulFailoverTime?.applyValue({ args0 -> args0 }))
            .lastSuccessfulTestFailoverTime(lastSuccessfulTestFailoverTime?.applyValue({ args0 -> args0 }))
            .policyFriendlyName(policyFriendlyName?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .primaryFabricFriendlyName(primaryFabricFriendlyName?.applyValue({ args0 -> args0 }))
            .primaryFabricProvider(primaryFabricProvider?.applyValue({ args0 -> args0 }))
            .primaryProtectionContainerFriendlyName(
                primaryProtectionContainerFriendlyName?.applyValue({ args0 ->
                    args0
                }),
            )
            .protectionClusterType(protectionClusterType?.applyValue({ args0 -> args0 }))
            .protectionState(protectionState?.applyValue({ args0 -> args0 }))
            .protectionStateDescription(protectionStateDescription?.applyValue({ args0 -> args0 }))
            .providerSpecificDetails(
                providerSpecificDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .recoveryContainerId(recoveryContainerId?.applyValue({ args0 -> args0 }))
            .recoveryFabricFriendlyName(recoveryFabricFriendlyName?.applyValue({ args0 -> args0 }))
            .recoveryFabricId(recoveryFabricId?.applyValue({ args0 -> args0 }))
            .recoveryProtectionContainerFriendlyName(
                recoveryProtectionContainerFriendlyName?.applyValue({ args0 ->
                    args0
                }),
            )
            .replicationHealth(replicationHealth?.applyValue({ args0 -> args0 }))
            .sharedDiskProperties(
                sharedDiskProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .testFailoverState(testFailoverState?.applyValue({ args0 -> args0 }))
            .testFailoverStateDescription(testFailoverStateDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationProtectionClusterPropertiesArgs].
 */
@PulumiTagMarker
public class ReplicationProtectionClusterPropertiesArgsBuilder internal constructor() {
    private var activeLocation: Output<String>? = null

    private var agentClusterId: Output<String>? = null

    private var allowedOperations: Output<List<String>>? = null

    private var areAllClusterNodesRegistered: Output<Boolean>? = null

    private var clusterFqdn: Output<String>? = null

    private var clusterNodeFqdns: Output<List<String>>? = null

    private var clusterProtectedItemIds: Output<List<String>>? = null

    private var clusterRegisteredNodes: Output<List<RegisteredClusterNodesArgs>>? = null

    private var currentScenario: Output<CurrentScenarioDetailsArgs>? = null

    private var healthErrors: Output<List<HealthErrorArgs>>? = null

    private var lastSuccessfulFailoverTime: Output<String>? = null

    private var lastSuccessfulTestFailoverTime: Output<String>? = null

    private var policyFriendlyName: Output<String>? = null

    private var policyId: Output<String>? = null

    private var primaryFabricFriendlyName: Output<String>? = null

    private var primaryFabricProvider: Output<String>? = null

    private var primaryProtectionContainerFriendlyName: Output<String>? = null

    private var protectionClusterType: Output<String>? = null

    private var protectionState: Output<String>? = null

    private var protectionStateDescription: Output<String>? = null

    private var providerSpecificDetails: Output<A2AReplicationProtectionClusterDetailsArgs>? = null

    private var recoveryContainerId: Output<String>? = null

    private var recoveryFabricFriendlyName: Output<String>? = null

    private var recoveryFabricId: Output<String>? = null

    private var recoveryProtectionContainerFriendlyName: Output<String>? = null

    private var replicationHealth: Output<String>? = null

    private var sharedDiskProperties: Output<SharedDiskReplicationItemPropertiesArgs>? = null

    private var testFailoverState: Output<String>? = null

    private var testFailoverStateDescription: Output<String>? = null

    /**
     * @param value The Current active location of the Protection cluster.
     */
    @JvmName("yswentuusayrjbph")
    public suspend fun activeLocation(`value`: Output<String>) {
        this.activeLocation = value
    }

    /**
     * @param value The Agent cluster Id.
     */
    @JvmName("fnsnbaxfpjspissd")
    public suspend fun agentClusterId(`value`: Output<String>) {
        this.agentClusterId = value
    }

    /**
     * @param value The allowed operations on the Replication protection cluster.
     */
    @JvmName("mwbehmocbrglksha")
    public suspend fun allowedOperations(`value`: Output<List<String>>) {
        this.allowedOperations = value
    }

    @JvmName("hmcttwbdecndmlyc")
    public suspend fun allowedOperations(vararg values: Output<String>) {
        this.allowedOperations = Output.all(values.asList())
    }

    /**
     * @param values The allowed operations on the Replication protection cluster.
     */
    @JvmName("thuutailjwcwvirt")
    public suspend fun allowedOperations(values: List<Output<String>>) {
        this.allowedOperations = Output.all(values)
    }

    /**
     * @param value A value indicating whether all nodes of the cluster are registered or not.
     */
    @JvmName("jdikhrkapcfrowjl")
    public suspend fun areAllClusterNodesRegistered(`value`: Output<Boolean>) {
        this.areAllClusterNodesRegistered = value
    }

    /**
     * @param value The cluster FQDN.
     */
    @JvmName("ofraxalnswuhbchg")
    public suspend fun clusterFqdn(`value`: Output<String>) {
        this.clusterFqdn = value
    }

    /**
     * @param value The List of cluster Node FQDNs.
     */
    @JvmName("kphdxfrmkmcgslqp")
    public suspend fun clusterNodeFqdns(`value`: Output<List<String>>) {
        this.clusterNodeFqdns = value
    }

    @JvmName("wkermsxxisrcqkbm")
    public suspend fun clusterNodeFqdns(vararg values: Output<String>) {
        this.clusterNodeFqdns = Output.all(values.asList())
    }

    /**
     * @param values The List of cluster Node FQDNs.
     */
    @JvmName("afsbvakcaguhmjai")
    public suspend fun clusterNodeFqdns(values: List<Output<String>>) {
        this.clusterNodeFqdns = Output.all(values)
    }

    /**
     * @param value The List of Protected Item Id's.
     */
    @JvmName("ayjmslhagvsejvxg")
    public suspend fun clusterProtectedItemIds(`value`: Output<List<String>>) {
        this.clusterProtectedItemIds = value
    }

    @JvmName("cigbrwbnusihjjxs")
    public suspend fun clusterProtectedItemIds(vararg values: Output<String>) {
        this.clusterProtectedItemIds = Output.all(values.asList())
    }

    /**
     * @param values The List of Protected Item Id's.
     */
    @JvmName("fjvntwohldepfjoo")
    public suspend fun clusterProtectedItemIds(values: List<Output<String>>) {
        this.clusterProtectedItemIds = Output.all(values)
    }

    /**
     * @param value The registered node details.
     */
    @JvmName("xodrcbkocachtjbc")
    public suspend fun clusterRegisteredNodes(`value`: Output<List<RegisteredClusterNodesArgs>>) {
        this.clusterRegisteredNodes = value
    }

    @JvmName("naudanhihtjuiqbo")
    public suspend fun clusterRegisteredNodes(vararg values: Output<RegisteredClusterNodesArgs>) {
        this.clusterRegisteredNodes = Output.all(values.asList())
    }

    /**
     * @param values The registered node details.
     */
    @JvmName("lduxpgxgdkgpffhy")
    public suspend fun clusterRegisteredNodes(values: List<Output<RegisteredClusterNodesArgs>>) {
        this.clusterRegisteredNodes = Output.all(values)
    }

    /**
     * @param value The current scenario.
     */
    @JvmName("futmbsubhkmqyava")
    public suspend fun currentScenario(`value`: Output<CurrentScenarioDetailsArgs>) {
        this.currentScenario = value
    }

    /**
     * @param value List of health errors.
     */
    @JvmName("sjrdpviovwvdedej")
    public suspend fun healthErrors(`value`: Output<List<HealthErrorArgs>>) {
        this.healthErrors = value
    }

    @JvmName("jbthwfdktobtuobx")
    public suspend fun healthErrors(vararg values: Output<HealthErrorArgs>) {
        this.healthErrors = Output.all(values.asList())
    }

    /**
     * @param values List of health errors.
     */
    @JvmName("vlwuufgmdvbqcrft")
    public suspend fun healthErrors(values: List<Output<HealthErrorArgs>>) {
        this.healthErrors = Output.all(values)
    }

    /**
     * @param value The last successful failover time.
     */
    @JvmName("fkanyghkybjnithq")
    public suspend fun lastSuccessfulFailoverTime(`value`: Output<String>) {
        this.lastSuccessfulFailoverTime = value
    }

    /**
     * @param value The last successful test failover time.
     */
    @JvmName("gbedqdkkwuenubil")
    public suspend fun lastSuccessfulTestFailoverTime(`value`: Output<String>) {
        this.lastSuccessfulTestFailoverTime = value
    }

    /**
     * @param value The name of Policy governing this PE.
     */
    @JvmName("rptugqxsgpxccpmk")
    public suspend fun policyFriendlyName(`value`: Output<String>) {
        this.policyFriendlyName = value
    }

    /**
     * @param value The Policy Id.
     */
    @JvmName("ropsgbribykjiahg")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The friendly name of the primary fabric.
     */
    @JvmName("xpbbtiulkyaxgqwu")
    public suspend fun primaryFabricFriendlyName(`value`: Output<String>) {
        this.primaryFabricFriendlyName = value
    }

    /**
     * @param value The fabric provider of the primary fabric.
     */
    @JvmName("idejrdwjyahtyooj")
    public suspend fun primaryFabricProvider(`value`: Output<String>) {
        this.primaryFabricProvider = value
    }

    /**
     * @param value The name of primary protection container friendly name.
     */
    @JvmName("okkxbungumgancxw")
    public suspend fun primaryProtectionContainerFriendlyName(`value`: Output<String>) {
        this.primaryProtectionContainerFriendlyName = value
    }

    /**
     * @param value The type of protection cluster type.
     */
    @JvmName("baujwcacsiqfmrgm")
    public suspend fun protectionClusterType(`value`: Output<String>) {
        this.protectionClusterType = value
    }

    /**
     * @param value The protection status.
     */
    @JvmName("thqjnrtvciobhdfv")
    public suspend fun protectionState(`value`: Output<String>) {
        this.protectionState = value
    }

    /**
     * @param value The protection state description.
     */
    @JvmName("hslweodtwrfhrkse")
    public suspend fun protectionStateDescription(`value`: Output<String>) {
        this.protectionStateDescription = value
    }

    /**
     * @param value The Replication cluster provider custom settings.
     */
    @JvmName("pdfeinhivoaygxqo")
    public suspend fun providerSpecificDetails(`value`: Output<A2AReplicationProtectionClusterDetailsArgs>) {
        this.providerSpecificDetails = value
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("ppqmrdplgrjvfoxc")
    public suspend fun recoveryContainerId(`value`: Output<String>) {
        this.recoveryContainerId = value
    }

    /**
     * @param value The friendly name of recovery fabric.
     */
    @JvmName("yturxwqtjsketfcu")
    public suspend fun recoveryFabricFriendlyName(`value`: Output<String>) {
        this.recoveryFabricFriendlyName = value
    }

    /**
     * @param value The Arm Id of recovery fabric.
     */
    @JvmName("jdsbxcgrfqrrakkl")
    public suspend fun recoveryFabricId(`value`: Output<String>) {
        this.recoveryFabricId = value
    }

    /**
     * @param value The name of recovery container friendly name.
     */
    @JvmName("itafkqkrfuewfixa")
    public suspend fun recoveryProtectionContainerFriendlyName(`value`: Output<String>) {
        this.recoveryProtectionContainerFriendlyName = value
    }

    /**
     * @param value The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
     */
    @JvmName("hygjkxuijvilfrvh")
    public suspend fun replicationHealth(`value`: Output<String>) {
        this.replicationHealth = value
    }

    /**
     * @param value The shared disk properties.
     */
    @JvmName("kgwdalgxypvwgotw")
    public suspend fun sharedDiskProperties(`value`: Output<SharedDiskReplicationItemPropertiesArgs>) {
        this.sharedDiskProperties = value
    }

    /**
     * @param value The Test failover state.
     */
    @JvmName("dnictkcclabhcpuf")
    public suspend fun testFailoverState(`value`: Output<String>) {
        this.testFailoverState = value
    }

    /**
     * @param value The Test failover state description.
     */
    @JvmName("spudmfdcvulawtrd")
    public suspend fun testFailoverStateDescription(`value`: Output<String>) {
        this.testFailoverStateDescription = value
    }

    /**
     * @param value The Current active location of the Protection cluster.
     */
    @JvmName("pfjinuoelpmahvtn")
    public suspend fun activeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeLocation = mapped
    }

    /**
     * @param value The Agent cluster Id.
     */
    @JvmName("xvpvihhykctpkkpu")
    public suspend fun agentClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentClusterId = mapped
    }

    /**
     * @param value The allowed operations on the Replication protection cluster.
     */
    @JvmName("qbjmhglhsrafqfhw")
    public suspend fun allowedOperations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param values The allowed operations on the Replication protection cluster.
     */
    @JvmName("alsywrxjholsttif")
    public suspend fun allowedOperations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param value A value indicating whether all nodes of the cluster are registered or not.
     */
    @JvmName("dsqddnwpmspnisxv")
    public suspend fun areAllClusterNodesRegistered(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.areAllClusterNodesRegistered = mapped
    }

    /**
     * @param value The cluster FQDN.
     */
    @JvmName("odydvcmnkvuiwswg")
    public suspend fun clusterFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterFqdn = mapped
    }

    /**
     * @param value The List of cluster Node FQDNs.
     */
    @JvmName("sqrrpxmjxqdmlgal")
    public suspend fun clusterNodeFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterNodeFqdns = mapped
    }

    /**
     * @param values The List of cluster Node FQDNs.
     */
    @JvmName("otvmdvpvncctvxce")
    public suspend fun clusterNodeFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterNodeFqdns = mapped
    }

    /**
     * @param value The List of Protected Item Id's.
     */
    @JvmName("cphdigvgogspsceo")
    public suspend fun clusterProtectedItemIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterProtectedItemIds = mapped
    }

    /**
     * @param values The List of Protected Item Id's.
     */
    @JvmName("eiaknabahxchhmdn")
    public suspend fun clusterProtectedItemIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterProtectedItemIds = mapped
    }

    /**
     * @param value The registered node details.
     */
    @JvmName("idjjcbwlqcrlqtnk")
    public suspend fun clusterRegisteredNodes(`value`: List<RegisteredClusterNodesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRegisteredNodes = mapped
    }

    /**
     * @param argument The registered node details.
     */
    @JvmName("dtcyopfsljvpimeb")
    public suspend fun clusterRegisteredNodes(argument: List<suspend RegisteredClusterNodesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegisteredClusterNodesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clusterRegisteredNodes = mapped
    }

    /**
     * @param argument The registered node details.
     */
    @JvmName("hjkosghqxvirjqgq")
    public suspend fun clusterRegisteredNodes(vararg argument: suspend RegisteredClusterNodesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegisteredClusterNodesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clusterRegisteredNodes = mapped
    }

    /**
     * @param argument The registered node details.
     */
    @JvmName("cxbkxtwfcdtutleq")
    public suspend fun clusterRegisteredNodes(argument: suspend RegisteredClusterNodesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RegisteredClusterNodesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.clusterRegisteredNodes = mapped
    }

    /**
     * @param values The registered node details.
     */
    @JvmName("cophebingqpqooej")
    public suspend fun clusterRegisteredNodes(vararg values: RegisteredClusterNodesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterRegisteredNodes = mapped
    }

    /**
     * @param value The current scenario.
     */
    @JvmName("ansrrkoehkcnlavx")
    public suspend fun currentScenario(`value`: CurrentScenarioDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentScenario = mapped
    }

    /**
     * @param argument The current scenario.
     */
    @JvmName("japrnfhbevrmqfmb")
    public suspend fun currentScenario(argument: suspend CurrentScenarioDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CurrentScenarioDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.currentScenario = mapped
    }

    /**
     * @param value List of health errors.
     */
    @JvmName("ermhlxlksvxhthak")
    public suspend fun healthErrors(`value`: List<HealthErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("oqctobphrmnhwvip")
    public suspend fun healthErrors(argument: List<suspend HealthErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HealthErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("gpwlisdyntqgecot")
    public suspend fun healthErrors(vararg argument: suspend HealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HealthErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("dmdrpyfjhvjfteiu")
    public suspend fun healthErrors(argument: suspend HealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HealthErrorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param values List of health errors.
     */
    @JvmName("yehykssrdjgsjwsi")
    public suspend fun healthErrors(vararg values: HealthErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthErrors = mapped
    }

    /**
     * @param value The last successful failover time.
     */
    @JvmName("asdojjtbitdlwtnf")
    public suspend fun lastSuccessfulFailoverTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastSuccessfulFailoverTime = mapped
    }

    /**
     * @param value The last successful test failover time.
     */
    @JvmName("plvwgcnjshvldflq")
    public suspend fun lastSuccessfulTestFailoverTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastSuccessfulTestFailoverTime = mapped
    }

    /**
     * @param value The name of Policy governing this PE.
     */
    @JvmName("cluxiqjimlgspkxl")
    public suspend fun policyFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyFriendlyName = mapped
    }

    /**
     * @param value The Policy Id.
     */
    @JvmName("rxuhndqxodnieqwf")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The friendly name of the primary fabric.
     */
    @JvmName("wefwacphhelotjcu")
    public suspend fun primaryFabricFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFabricFriendlyName = mapped
    }

    /**
     * @param value The fabric provider of the primary fabric.
     */
    @JvmName("cnpcopjlqacunsnj")
    public suspend fun primaryFabricProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryFabricProvider = mapped
    }

    /**
     * @param value The name of primary protection container friendly name.
     */
    @JvmName("wneepsquolmfjacv")
    public suspend fun primaryProtectionContainerFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryProtectionContainerFriendlyName = mapped
    }

    /**
     * @param value The type of protection cluster type.
     */
    @JvmName("qgqmlhijumumnglu")
    public suspend fun protectionClusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionClusterType = mapped
    }

    /**
     * @param value The protection status.
     */
    @JvmName("itekmliqlinwludk")
    public suspend fun protectionState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value The protection state description.
     */
    @JvmName("vvcpdedrblsmgfwa")
    public suspend fun protectionStateDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionStateDescription = mapped
    }

    /**
     * @param value The Replication cluster provider custom settings.
     */
    @JvmName("rgawhuootylgshyo")
    public suspend fun providerSpecificDetails(`value`: A2AReplicationProtectionClusterDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSpecificDetails = mapped
    }

    /**
     * @param argument The Replication cluster provider custom settings.
     */
    @JvmName("xkjbuvvdwoxsatuf")
    public suspend fun providerSpecificDetails(argument: suspend A2AReplicationProtectionClusterDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = A2AReplicationProtectionClusterDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.providerSpecificDetails = mapped
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("likcjddeocajvlvg")
    public suspend fun recoveryContainerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryContainerId = mapped
    }

    /**
     * @param value The friendly name of recovery fabric.
     */
    @JvmName("nqqkdkdencceqceb")
    public suspend fun recoveryFabricFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryFabricFriendlyName = mapped
    }

    /**
     * @param value The Arm Id of recovery fabric.
     */
    @JvmName("jsayumdhbsoooeue")
    public suspend fun recoveryFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryFabricId = mapped
    }

    /**
     * @param value The name of recovery container friendly name.
     */
    @JvmName("crnuhgrgeoklpxnc")
    public suspend fun recoveryProtectionContainerFriendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryProtectionContainerFriendlyName = mapped
    }

    /**
     * @param value The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
     */
    @JvmName("gnfnbqayguqiflfm")
    public suspend fun replicationHealth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationHealth = mapped
    }

    /**
     * @param value The shared disk properties.
     */
    @JvmName("yylmtvceocnaxgth")
    public suspend fun sharedDiskProperties(`value`: SharedDiskReplicationItemPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedDiskProperties = mapped
    }

    /**
     * @param argument The shared disk properties.
     */
    @JvmName("yxrqqrlukvtfnbbj")
    public suspend fun sharedDiskProperties(argument: suspend SharedDiskReplicationItemPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SharedDiskReplicationItemPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedDiskProperties = mapped
    }

    /**
     * @param value The Test failover state.
     */
    @JvmName("ptxqervmxjbkgsbi")
    public suspend fun testFailoverState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testFailoverState = mapped
    }

    /**
     * @param value The Test failover state description.
     */
    @JvmName("iytuhgwooaumaoic")
    public suspend fun testFailoverStateDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testFailoverStateDescription = mapped
    }

    internal fun build(): ReplicationProtectionClusterPropertiesArgs =
        ReplicationProtectionClusterPropertiesArgs(
            activeLocation = activeLocation,
            agentClusterId = agentClusterId,
            allowedOperations = allowedOperations,
            areAllClusterNodesRegistered = areAllClusterNodesRegistered,
            clusterFqdn = clusterFqdn,
            clusterNodeFqdns = clusterNodeFqdns,
            clusterProtectedItemIds = clusterProtectedItemIds,
            clusterRegisteredNodes = clusterRegisteredNodes,
            currentScenario = currentScenario,
            healthErrors = healthErrors,
            lastSuccessfulFailoverTime = lastSuccessfulFailoverTime,
            lastSuccessfulTestFailoverTime = lastSuccessfulTestFailoverTime,
            policyFriendlyName = policyFriendlyName,
            policyId = policyId,
            primaryFabricFriendlyName = primaryFabricFriendlyName,
            primaryFabricProvider = primaryFabricProvider,
            primaryProtectionContainerFriendlyName = primaryProtectionContainerFriendlyName,
            protectionClusterType = protectionClusterType,
            protectionState = protectionState,
            protectionStateDescription = protectionStateDescription,
            providerSpecificDetails = providerSpecificDetails,
            recoveryContainerId = recoveryContainerId,
            recoveryFabricFriendlyName = recoveryFabricFriendlyName,
            recoveryFabricId = recoveryFabricId,
            recoveryProtectionContainerFriendlyName = recoveryProtectionContainerFriendlyName,
            replicationHealth = replicationHealth,
            sharedDiskProperties = sharedDiskProperties,
            testFailoverState = testFailoverState,
            testFailoverStateDescription = testFailoverStateDescription,
        )
}
