@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.SharedDiskReplicationItemPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Shared Disk Replication item custom data details.
 * @property activeLocation The Current active location of the PE.
 * @property allowedOperations The allowed operations on the Replication protected item.
 * @property currentScenario The current scenario.
 * @property healthErrors List of health errors.
 * @property protectionState The protection state of shared disk.
 * @property replicationHealth The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
 * @property sharedDiskProviderSpecificDetails The Replication provider custom settings.
 * @property testFailoverState The tfo state of shared disk.
 */
public data class SharedDiskReplicationItemPropertiesArgs(
    public val activeLocation: Output<String>? = null,
    public val allowedOperations: Output<List<String>>? = null,
    public val currentScenario: Output<CurrentScenarioDetailsArgs>? = null,
    public val healthErrors: Output<List<HealthErrorArgs>>? = null,
    public val protectionState: Output<String>? = null,
    public val replicationHealth: Output<String>? = null,
    public val sharedDiskProviderSpecificDetails: Output<A2ASharedDiskReplicationDetailsArgs>? = null,
    public val testFailoverState: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.SharedDiskReplicationItemPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.SharedDiskReplicationItemPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.SharedDiskReplicationItemPropertiesArgs.builder()
            .activeLocation(activeLocation?.applyValue({ args0 -> args0 }))
            .allowedOperations(allowedOperations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .currentScenario(currentScenario?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthErrors(
                healthErrors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protectionState(protectionState?.applyValue({ args0 -> args0 }))
            .replicationHealth(replicationHealth?.applyValue({ args0 -> args0 }))
            .sharedDiskProviderSpecificDetails(
                sharedDiskProviderSpecificDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .testFailoverState(testFailoverState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedDiskReplicationItemPropertiesArgs].
 */
@PulumiTagMarker
public class SharedDiskReplicationItemPropertiesArgsBuilder internal constructor() {
    private var activeLocation: Output<String>? = null

    private var allowedOperations: Output<List<String>>? = null

    private var currentScenario: Output<CurrentScenarioDetailsArgs>? = null

    private var healthErrors: Output<List<HealthErrorArgs>>? = null

    private var protectionState: Output<String>? = null

    private var replicationHealth: Output<String>? = null

    private var sharedDiskProviderSpecificDetails: Output<A2ASharedDiskReplicationDetailsArgs>? = null

    private var testFailoverState: Output<String>? = null

    /**
     * @param value The Current active location of the PE.
     */
    @JvmName("smenjkccxvetiisv")
    public suspend fun activeLocation(`value`: Output<String>) {
        this.activeLocation = value
    }

    /**
     * @param value The allowed operations on the Replication protected item.
     */
    @JvmName("psykvuspibktuiqt")
    public suspend fun allowedOperations(`value`: Output<List<String>>) {
        this.allowedOperations = value
    }

    @JvmName("wgdgurupsfpknyhc")
    public suspend fun allowedOperations(vararg values: Output<String>) {
        this.allowedOperations = Output.all(values.asList())
    }

    /**
     * @param values The allowed operations on the Replication protected item.
     */
    @JvmName("xlqwvnxoufcwlbuh")
    public suspend fun allowedOperations(values: List<Output<String>>) {
        this.allowedOperations = Output.all(values)
    }

    /**
     * @param value The current scenario.
     */
    @JvmName("ufsiptsqjqbilfcn")
    public suspend fun currentScenario(`value`: Output<CurrentScenarioDetailsArgs>) {
        this.currentScenario = value
    }

    /**
     * @param value List of health errors.
     */
    @JvmName("laiwwuqcjmwnxbdw")
    public suspend fun healthErrors(`value`: Output<List<HealthErrorArgs>>) {
        this.healthErrors = value
    }

    @JvmName("qsokbglsrwonfjmn")
    public suspend fun healthErrors(vararg values: Output<HealthErrorArgs>) {
        this.healthErrors = Output.all(values.asList())
    }

    /**
     * @param values List of health errors.
     */
    @JvmName("xxjvnmnyhsoldygn")
    public suspend fun healthErrors(values: List<Output<HealthErrorArgs>>) {
        this.healthErrors = Output.all(values)
    }

    /**
     * @param value The protection state of shared disk.
     */
    @JvmName("gtchakeqbnukgvof")
    public suspend fun protectionState(`value`: Output<String>) {
        this.protectionState = value
    }

    /**
     * @param value The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
     */
    @JvmName("lxudxcrmmobtxipa")
    public suspend fun replicationHealth(`value`: Output<String>) {
        this.replicationHealth = value
    }

    /**
     * @param value The Replication provider custom settings.
     */
    @JvmName("rfpniaeqpsnolqad")
    public suspend fun sharedDiskProviderSpecificDetails(`value`: Output<A2ASharedDiskReplicationDetailsArgs>) {
        this.sharedDiskProviderSpecificDetails = value
    }

    /**
     * @param value The tfo state of shared disk.
     */
    @JvmName("oesxjntdeoacgcjg")
    public suspend fun testFailoverState(`value`: Output<String>) {
        this.testFailoverState = value
    }

    /**
     * @param value The Current active location of the PE.
     */
    @JvmName("yxrhygtxkagpxedv")
    public suspend fun activeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeLocation = mapped
    }

    /**
     * @param value The allowed operations on the Replication protected item.
     */
    @JvmName("myantnaljtdbaslk")
    public suspend fun allowedOperations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param values The allowed operations on the Replication protected item.
     */
    @JvmName("dlrxsfjhbdyqqyee")
    public suspend fun allowedOperations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param value The current scenario.
     */
    @JvmName("hymgufpnwwlbwytf")
    public suspend fun currentScenario(`value`: CurrentScenarioDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentScenario = mapped
    }

    /**
     * @param argument The current scenario.
     */
    @JvmName("gxlnvdfxwtyxahcn")
    public suspend fun currentScenario(argument: suspend CurrentScenarioDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CurrentScenarioDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.currentScenario = mapped
    }

    /**
     * @param value List of health errors.
     */
    @JvmName("kaxwlkhkbxuihklo")
    public suspend fun healthErrors(`value`: List<HealthErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("yyrtgjxxqslaoxaw")
    public suspend fun healthErrors(argument: List<suspend HealthErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HealthErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("dgmpiceorvpkphtd")
    public suspend fun healthErrors(vararg argument: suspend HealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HealthErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param argument List of health errors.
     */
    @JvmName("lwhoqjujgbfbehec")
    public suspend fun healthErrors(argument: suspend HealthErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HealthErrorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.healthErrors = mapped
    }

    /**
     * @param values List of health errors.
     */
    @JvmName("xhjrejxayrxddmpd")
    public suspend fun healthErrors(vararg values: HealthErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthErrors = mapped
    }

    /**
     * @param value The protection state of shared disk.
     */
    @JvmName("vtoruwahfxpjewbs")
    public suspend fun protectionState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
     */
    @JvmName("ruceyofjqudwauor")
    public suspend fun replicationHealth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationHealth = mapped
    }

    /**
     * @param value The Replication provider custom settings.
     */
    @JvmName("bbkoccrigkevlnqj")
    public suspend fun sharedDiskProviderSpecificDetails(`value`: A2ASharedDiskReplicationDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedDiskProviderSpecificDetails = mapped
    }

    /**
     * @param argument The Replication provider custom settings.
     */
    @JvmName("hkjjuvoraefajfhy")
    public suspend fun sharedDiskProviderSpecificDetails(argument: suspend A2ASharedDiskReplicationDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = A2ASharedDiskReplicationDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sharedDiskProviderSpecificDetails = mapped
    }

    /**
     * @param value The tfo state of shared disk.
     */
    @JvmName("dtwtibhwgokncdar")
    public suspend fun testFailoverState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testFailoverState = mapped
    }

    internal fun build(): SharedDiskReplicationItemPropertiesArgs =
        SharedDiskReplicationItemPropertiesArgs(
            activeLocation = activeLocation,
            allowedOperations = allowedOperations,
            currentScenario = currentScenario,
            healthErrors = healthErrors,
            protectionState = protectionState,
            replicationHealth = replicationHealth,
            sharedDiskProviderSpecificDetails = sharedDiskProviderSpecificDetails,
            testFailoverState = testFailoverState,
        )
}
