@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.YearlyRetentionScheduleArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.MonthOfYear
import com.pulumi.azurenative.recoveryservices.kotlin.enums.RetentionScheduleFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Yearly retention schedule.
 * @property monthsOfYear List of months of year of yearly retention policy.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionScheduleDaily Daily retention format for yearly retention policy.
 * @property retentionScheduleFormatType Retention schedule format for yearly retention policy.
 * @property retentionScheduleWeekly Weekly retention format for yearly retention policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class YearlyRetentionScheduleArgs(
    public val monthsOfYear: Output<List<MonthOfYear>>? = null,
    public val retentionDuration: Output<RetentionDurationArgs>? = null,
    public val retentionScheduleDaily: Output<DailyRetentionFormatArgs>? = null,
    public val retentionScheduleFormatType: Output<Either<String, RetentionScheduleFormat>>? = null,
    public val retentionScheduleWeekly: Output<WeeklyRetentionFormatArgs>? = null,
    public val retentionTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.YearlyRetentionScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.YearlyRetentionScheduleArgs = com.pulumi.azurenative.recoveryservices.inputs.YearlyRetentionScheduleArgs.builder()
        .monthsOfYear(
            monthsOfYear?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .retentionDuration(retentionDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .retentionScheduleDaily(
            retentionScheduleDaily?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .retentionScheduleFormatType(
            retentionScheduleFormatType?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .retentionScheduleWeekly(
            retentionScheduleWeekly?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .retentionTimes(retentionTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [YearlyRetentionScheduleArgs].
 */
@PulumiTagMarker
public class YearlyRetentionScheduleArgsBuilder internal constructor() {
    private var monthsOfYear: Output<List<MonthOfYear>>? = null

    private var retentionDuration: Output<RetentionDurationArgs>? = null

    private var retentionScheduleDaily: Output<DailyRetentionFormatArgs>? = null

    private var retentionScheduleFormatType: Output<Either<String, RetentionScheduleFormat>>? = null

    private var retentionScheduleWeekly: Output<WeeklyRetentionFormatArgs>? = null

    private var retentionTimes: Output<List<String>>? = null

    /**
     * @param value List of months of year of yearly retention policy.
     */
    @JvmName("clrdhpchtyxnhycu")
    public suspend fun monthsOfYear(`value`: Output<List<MonthOfYear>>) {
        this.monthsOfYear = value
    }

    @JvmName("kmmfklqjxyajfwwx")
    public suspend fun monthsOfYear(vararg values: Output<MonthOfYear>) {
        this.monthsOfYear = Output.all(values.asList())
    }

    /**
     * @param values List of months of year of yearly retention policy.
     */
    @JvmName("abaanqgkxrjepdtc")
    public suspend fun monthsOfYear(values: List<Output<MonthOfYear>>) {
        this.monthsOfYear = Output.all(values)
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("idkqkijfqboemxbu")
    public suspend fun retentionDuration(`value`: Output<RetentionDurationArgs>) {
        this.retentionDuration = value
    }

    /**
     * @param value Daily retention format for yearly retention policy.
     */
    @JvmName("bnixbbgyarewyrfl")
    public suspend fun retentionScheduleDaily(`value`: Output<DailyRetentionFormatArgs>) {
        this.retentionScheduleDaily = value
    }

    /**
     * @param value Retention schedule format for yearly retention policy.
     */
    @JvmName("slhcvajocwxcsrig")
    public suspend fun retentionScheduleFormatType(`value`: Output<Either<String, RetentionScheduleFormat>>) {
        this.retentionScheduleFormatType = value
    }

    /**
     * @param value Weekly retention format for yearly retention policy.
     */
    @JvmName("woktcnkfuayfhscn")
    public suspend fun retentionScheduleWeekly(`value`: Output<WeeklyRetentionFormatArgs>) {
        this.retentionScheduleWeekly = value
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("tqlvvaeghseyvxvu")
    public suspend fun retentionTimes(`value`: Output<List<String>>) {
        this.retentionTimes = value
    }

    @JvmName("sylaqwrxfmfkhipj")
    public suspend fun retentionTimes(vararg values: Output<String>) {
        this.retentionTimes = Output.all(values.asList())
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("adfxgwaxrroawgbv")
    public suspend fun retentionTimes(values: List<Output<String>>) {
        this.retentionTimes = Output.all(values)
    }

    /**
     * @param value List of months of year of yearly retention policy.
     */
    @JvmName("jpptuubsojupqxdl")
    public suspend fun monthsOfYear(`value`: List<MonthOfYear>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthsOfYear = mapped
    }

    /**
     * @param values List of months of year of yearly retention policy.
     */
    @JvmName("ckthrxehietfovyv")
    public suspend fun monthsOfYear(vararg values: MonthOfYear) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthsOfYear = mapped
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("gkvtjqoenjxqqwrc")
    public suspend fun retentionDuration(`value`: RetentionDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param argument Retention duration of retention Policy.
     */
    @JvmName("bsycjidfmfyjlmgo")
    public suspend fun retentionDuration(argument: suspend RetentionDurationArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDuration = mapped
    }

    /**
     * @param value Daily retention format for yearly retention policy.
     */
    @JvmName("lkadwdkaacabspmd")
    public suspend fun retentionScheduleDaily(`value`: DailyRetentionFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleDaily = mapped
    }

    /**
     * @param argument Daily retention format for yearly retention policy.
     */
    @JvmName("vcnsaegwoeklboda")
    public suspend fun retentionScheduleDaily(argument: suspend DailyRetentionFormatArgsBuilder.() -> Unit) {
        val toBeMapped = DailyRetentionFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionScheduleDaily = mapped
    }

    /**
     * @param value Retention schedule format for yearly retention policy.
     */
    @JvmName("xphgfhklrqthflfs")
    public suspend fun retentionScheduleFormatType(`value`: Either<String, RetentionScheduleFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Retention schedule format for yearly retention policy.
     */
    @JvmName("orqvsibetdgpbawl")
    public fun retentionScheduleFormatType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RetentionScheduleFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Retention schedule format for yearly retention policy.
     */
    @JvmName("fthqtnxxkuotnrdp")
    public fun retentionScheduleFormatType(`value`: RetentionScheduleFormat) {
        val toBeMapped = Either.ofRight<String, RetentionScheduleFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Weekly retention format for yearly retention policy.
     */
    @JvmName("hlgwsxlswyvcfkgb")
    public suspend fun retentionScheduleWeekly(`value`: WeeklyRetentionFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleWeekly = mapped
    }

    /**
     * @param argument Weekly retention format for yearly retention policy.
     */
    @JvmName("vfhxpfgqkbyfqnxj")
    public suspend fun retentionScheduleWeekly(argument: suspend WeeklyRetentionFormatArgsBuilder.() -> Unit) {
        val toBeMapped = WeeklyRetentionFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionScheduleWeekly = mapped
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("akpldilleqdffcan")
    public suspend fun retentionTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("nikuckvovsqspiix")
    public suspend fun retentionTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    internal fun build(): YearlyRetentionScheduleArgs = YearlyRetentionScheduleArgs(
        monthsOfYear = monthsOfYear,
        retentionDuration = retentionDuration,
        retentionScheduleDaily = retentionScheduleDaily,
        retentionScheduleFormatType = retentionScheduleFormatType,
        retentionScheduleWeekly = retentionScheduleWeekly,
        retentionTimes = retentionTimes,
    )
}
