@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A2A protected managed disk details.
 * @property allowedDiskLevelOperation The disk level operations list.
 * @property dataPendingAtSourceAgentInMB The data pending at source virtual machine in MB.
 * @property dataPendingInStagingStorageAccountInMB The data pending for replication in MB at staging account.
 * @property dekKeyVaultArmId The KeyVault resource id for secret (BEK).
 * @property diskCapacityInBytes The disk capacity in bytes.
 * @property diskId The managed disk Arm id.
 * @property diskName The disk name.
 * @property diskState The disk state.
 * @property diskType The type of disk.
 * @property failoverDiskName The failover name for the managed disk.
 * @property isDiskEncrypted A value indicating whether vm has encrypted os disk or not.
 * @property isDiskKeyEncrypted A value indicating whether disk key got encrypted or not.
 * @property kekKeyVaultArmId The KeyVault resource id for key (KEK).
 * @property keyIdentifier The key URL / identifier (KEK).
 * @property monitoringJobType The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
 * @property monitoringPercentageCompletion The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
 * @property primaryDiskEncryptionSetId The primary disk encryption set Id.
 * @property primaryStagingAzureStorageAccountId The primary staging storage account.
 * @property recoveryDiskEncryptionSetId The recovery disk encryption set Id.
 * @property recoveryOrignalTargetDiskId Recovery original target disk Arm Id.
 * @property recoveryReplicaDiskAccountType The replica disk type. Its an optional value and will be same as source disk type if not user provided.
 * @property recoveryReplicaDiskId Recovery replica disk Arm Id.
 * @property recoveryResourceGroupId The recovery disk resource group Arm Id.
 * @property recoveryTargetDiskAccountType The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
 * @property recoveryTargetDiskId Recovery target disk Arm Id.
 * @property resyncRequired A value indicating whether resync is required for this disk.
 * @property secretIdentifier The secret URL / identifier (BEK).
 * @property tfoDiskName The test failover name for the managed disk.
 */
public data class A2AProtectedManagedDiskDetailsResponse(
    public val allowedDiskLevelOperation: List<String>? = null,
    public val dataPendingAtSourceAgentInMB: Double? = null,
    public val dataPendingInStagingStorageAccountInMB: Double? = null,
    public val dekKeyVaultArmId: String? = null,
    public val diskCapacityInBytes: Double? = null,
    public val diskId: String? = null,
    public val diskName: String? = null,
    public val diskState: String? = null,
    public val diskType: String? = null,
    public val failoverDiskName: String? = null,
    public val isDiskEncrypted: Boolean? = null,
    public val isDiskKeyEncrypted: Boolean? = null,
    public val kekKeyVaultArmId: String? = null,
    public val keyIdentifier: String? = null,
    public val monitoringJobType: String? = null,
    public val monitoringPercentageCompletion: Int? = null,
    public val primaryDiskEncryptionSetId: String? = null,
    public val primaryStagingAzureStorageAccountId: String? = null,
    public val recoveryDiskEncryptionSetId: String? = null,
    public val recoveryOrignalTargetDiskId: String? = null,
    public val recoveryReplicaDiskAccountType: String? = null,
    public val recoveryReplicaDiskId: String? = null,
    public val recoveryResourceGroupId: String? = null,
    public val recoveryTargetDiskAccountType: String? = null,
    public val recoveryTargetDiskId: String? = null,
    public val resyncRequired: Boolean? = null,
    public val secretIdentifier: String? = null,
    public val tfoDiskName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AProtectedManagedDiskDetailsResponse): A2AProtectedManagedDiskDetailsResponse = A2AProtectedManagedDiskDetailsResponse(
            allowedDiskLevelOperation = javaType.allowedDiskLevelOperation().map({ args0 -> args0 }),
            dataPendingAtSourceAgentInMB = javaType.dataPendingAtSourceAgentInMB().map({ args0 ->
                args0
            }).orElse(null),
            dataPendingInStagingStorageAccountInMB = javaType.dataPendingInStagingStorageAccountInMB().map({ args0 ->
                args0
            }).orElse(null),
            dekKeyVaultArmId = javaType.dekKeyVaultArmId().map({ args0 -> args0 }).orElse(null),
            diskCapacityInBytes = javaType.diskCapacityInBytes().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            diskName = javaType.diskName().map({ args0 -> args0 }).orElse(null),
            diskState = javaType.diskState().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            failoverDiskName = javaType.failoverDiskName().map({ args0 -> args0 }).orElse(null),
            isDiskEncrypted = javaType.isDiskEncrypted().map({ args0 -> args0 }).orElse(null),
            isDiskKeyEncrypted = javaType.isDiskKeyEncrypted().map({ args0 -> args0 }).orElse(null),
            kekKeyVaultArmId = javaType.kekKeyVaultArmId().map({ args0 -> args0 }).orElse(null),
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
            monitoringJobType = javaType.monitoringJobType().map({ args0 -> args0 }).orElse(null),
            monitoringPercentageCompletion = javaType.monitoringPercentageCompletion().map({ args0 ->
                args0
            }).orElse(null),
            primaryDiskEncryptionSetId = javaType.primaryDiskEncryptionSetId().map({ args0 ->
                args0
            }).orElse(null),
            primaryStagingAzureStorageAccountId = javaType.primaryStagingAzureStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryDiskEncryptionSetId = javaType.recoveryDiskEncryptionSetId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryOrignalTargetDiskId = javaType.recoveryOrignalTargetDiskId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryReplicaDiskAccountType = javaType.recoveryReplicaDiskAccountType().map({ args0 ->
                args0
            }).orElse(null),
            recoveryReplicaDiskId = javaType.recoveryReplicaDiskId().map({ args0 -> args0 }).orElse(null),
            recoveryResourceGroupId = javaType.recoveryResourceGroupId().map({ args0 -> args0 }).orElse(null),
            recoveryTargetDiskAccountType = javaType.recoveryTargetDiskAccountType().map({ args0 ->
                args0
            }).orElse(null),
            recoveryTargetDiskId = javaType.recoveryTargetDiskId().map({ args0 -> args0 }).orElse(null),
            resyncRequired = javaType.resyncRequired().map({ args0 -> args0 }).orElse(null),
            secretIdentifier = javaType.secretIdentifier().map({ args0 -> args0 }).orElse(null),
            tfoDiskName = javaType.tfoDiskName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
