@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A2A provider specific settings.
 * @property agentAutoUpdateStatus A value indicating whether the auto update is enabled.
 * @property automationAccountArmId The automation account arm id.
 * @property automationAccountAuthenticationType A value indicating the type authentication to use for automation Account.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'A2A'.
 * @property jobScheduleName The job schedule arm name.
 * @property scheduleName The schedule arm name.
 */
public data class A2AProtectionContainerMappingDetailsResponse(
    public val agentAutoUpdateStatus: String? = null,
    public val automationAccountArmId: String? = null,
    public val automationAccountAuthenticationType: String? = null,
    public val instanceType: String,
    public val jobScheduleName: String? = null,
    public val scheduleName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AProtectionContainerMappingDetailsResponse): A2AProtectionContainerMappingDetailsResponse = A2AProtectionContainerMappingDetailsResponse(
            agentAutoUpdateStatus = javaType.agentAutoUpdateStatus().map({ args0 -> args0 }).orElse(null),
            automationAccountArmId = javaType.automationAccountArmId().map({ args0 -> args0 }).orElse(null),
            automationAccountAuthenticationType = javaType.automationAccountAuthenticationType().map({ args0 ->
                args0
            }).orElse(null),
            instanceType = javaType.instanceType(),
            jobScheduleName = javaType.jobScheduleName().map({ args0 -> args0 }).orElse(null),
            scheduleName = javaType.scheduleName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
