@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A2A provider specific settings.
 * @property agentCertificateExpiryDate Agent certificate expiry date.
 * @property agentExpiryDate Agent expiry date.
 * @property agentVersion The agent version.
 * @property autoProtectionOfDataDisk A value indicating whether the auto protection is enabled.
 * @property fabricObjectId The fabric specific object Id of the virtual machine.
 * @property initialPrimaryExtendedLocation The initial primary extended location.
 * @property initialPrimaryFabricLocation The initial primary fabric location.
 * @property initialPrimaryZone The initial primary availability zone.
 * @property initialRecoveryExtendedLocation The initial recovery extended location.
 * @property initialRecoveryFabricLocation The initial recovery fabric location.
 * @property initialRecoveryZone The initial recovery availability zone.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property isReplicationAgentCertificateUpdateRequired A value indicating whether agent certificate update is required.
 * @property isReplicationAgentUpdateRequired A value indicating whether replication agent update is required.
 * @property lastHeartbeat The last heartbeat received from the source server.
 * @property lastRpoCalculatedTime The time (in UTC) when the last RPO value was calculated by Protection Service.
 * @property lifecycleId An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
 * @property managementId The management Id.
 * @property monitoringJobType The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
 * @property monitoringPercentageCompletion The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
 * @property multiVmGroupCreateOption Whether Multi VM group is auto created or specified by user.
 * @property multiVmGroupId The multi vm group Id.
 * @property multiVmGroupName The multi vm group name.
 * @property osType The type of operating system.
 * @property primaryAvailabilityZone The primary availability zone.
 * @property primaryExtendedLocation The primary Extended Location.
 * @property primaryFabricLocation Primary fabric location.
 * @property protectedDisks The list of protected disks.
 * @property protectedManagedDisks The list of protected managed disks.
 * @property recoveryAvailabilitySet The recovery availability set.
 * @property recoveryAvailabilityZone The recovery availability zone.
 * @property recoveryAzureGeneration The recovery azure generation.
 * @property recoveryAzureResourceGroupId The recovery resource group.
 * @property recoveryAzureVMName The name of recovery virtual machine.
 * @property recoveryAzureVMSize The size of recovery virtual machine.
 * @property recoveryBootDiagStorageAccountId The recovery boot diagnostic storage account Arm Id.
 * @property recoveryCapacityReservationGroupId The recovery capacity reservation group Id.
 * @property recoveryCloudService The recovery cloud service.
 * @property recoveryExtendedLocation The recovery Extended Location.
 * @property recoveryFabricLocation The recovery fabric location.
 * @property recoveryFabricObjectId The recovery fabric object Id.
 * @property recoveryProximityPlacementGroupId The recovery proximity placement group Id.
 * @property recoveryVirtualMachineScaleSetId The recovery virtual machine scale set id.
 * @property rpoInSeconds The last RPO value in seconds.
 * @property selectedRecoveryAzureNetworkId The recovery virtual network.
 * @property selectedTfoAzureNetworkId The test failover virtual network.
 * @property testFailoverRecoveryFabricObjectId The test failover fabric object Id.
 * @property tfoAzureVMName The test failover vm name.
 * @property unprotectedDisks The list of unprotected disks.
 * @property vmEncryptionType The encryption type of the VM.
 * @property vmNics The virtual machine nic details.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 * @property vmSyncedConfigDetails The synced configuration details.
 */
public data class A2AReplicationDetailsResponse(
    public val agentCertificateExpiryDate: String,
    public val agentExpiryDate: String? = null,
    public val agentVersion: String? = null,
    public val autoProtectionOfDataDisk: String? = null,
    public val fabricObjectId: String? = null,
    public val initialPrimaryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialPrimaryFabricLocation: String,
    public val initialPrimaryZone: String,
    public val initialRecoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialRecoveryFabricLocation: String,
    public val initialRecoveryZone: String,
    public val instanceType: String,
    public val isReplicationAgentCertificateUpdateRequired: Boolean? = null,
    public val isReplicationAgentUpdateRequired: Boolean? = null,
    public val lastHeartbeat: String? = null,
    public val lastRpoCalculatedTime: String? = null,
    public val lifecycleId: String? = null,
    public val managementId: String? = null,
    public val monitoringJobType: String? = null,
    public val monitoringPercentageCompletion: Int? = null,
    public val multiVmGroupCreateOption: String? = null,
    public val multiVmGroupId: String? = null,
    public val multiVmGroupName: String? = null,
    public val osType: String? = null,
    public val primaryAvailabilityZone: String? = null,
    public val primaryExtendedLocation: ExtendedLocationResponse? = null,
    public val primaryFabricLocation: String? = null,
    public val protectedDisks: List<A2AProtectedDiskDetailsResponse>? = null,
    public val protectedManagedDisks: List<A2AProtectedManagedDiskDetailsResponse>? = null,
    public val recoveryAvailabilitySet: String? = null,
    public val recoveryAvailabilityZone: String? = null,
    public val recoveryAzureGeneration: String,
    public val recoveryAzureResourceGroupId: String? = null,
    public val recoveryAzureVMName: String? = null,
    public val recoveryAzureVMSize: String? = null,
    public val recoveryBootDiagStorageAccountId: String? = null,
    public val recoveryCapacityReservationGroupId: String? = null,
    public val recoveryCloudService: String? = null,
    public val recoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val recoveryFabricLocation: String? = null,
    public val recoveryFabricObjectId: String? = null,
    public val recoveryProximityPlacementGroupId: String? = null,
    public val recoveryVirtualMachineScaleSetId: String? = null,
    public val rpoInSeconds: Double? = null,
    public val selectedRecoveryAzureNetworkId: String? = null,
    public val selectedTfoAzureNetworkId: String? = null,
    public val testFailoverRecoveryFabricObjectId: String? = null,
    public val tfoAzureVMName: String? = null,
    public val unprotectedDisks: List<A2AUnprotectedDiskDetailsResponse>? = null,
    public val vmEncryptionType: String,
    public val vmNics: List<VMNicDetailsResponse>? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
    public val vmSyncedConfigDetails: AzureToAzureVmSyncedConfigDetailsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AReplicationDetailsResponse): A2AReplicationDetailsResponse = A2AReplicationDetailsResponse(
            agentCertificateExpiryDate = javaType.agentCertificateExpiryDate(),
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            autoProtectionOfDataDisk = javaType.autoProtectionOfDataDisk().map({ args0 -> args0 }).orElse(null),
            fabricObjectId = javaType.fabricObjectId().map({ args0 -> args0 }).orElse(null),
            initialPrimaryExtendedLocation = javaType.initialPrimaryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialPrimaryFabricLocation = javaType.initialPrimaryFabricLocation(),
            initialPrimaryZone = javaType.initialPrimaryZone(),
            initialRecoveryExtendedLocation = javaType.initialRecoveryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialRecoveryFabricLocation = javaType.initialRecoveryFabricLocation(),
            initialRecoveryZone = javaType.initialRecoveryZone(),
            instanceType = javaType.instanceType(),
            isReplicationAgentCertificateUpdateRequired = javaType.isReplicationAgentCertificateUpdateRequired().map({ args0 ->
                args0
            }).orElse(null),
            isReplicationAgentUpdateRequired = javaType.isReplicationAgentUpdateRequired().map({ args0 ->
                args0
            }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            lifecycleId = javaType.lifecycleId().map({ args0 -> args0 }).orElse(null),
            managementId = javaType.managementId().map({ args0 -> args0 }).orElse(null),
            monitoringJobType = javaType.monitoringJobType().map({ args0 -> args0 }).orElse(null),
            monitoringPercentageCompletion = javaType.monitoringPercentageCompletion().map({ args0 ->
                args0
            }).orElse(null),
            multiVmGroupCreateOption = javaType.multiVmGroupCreateOption().map({ args0 -> args0 }).orElse(null),
            multiVmGroupId = javaType.multiVmGroupId().map({ args0 -> args0 }).orElse(null),
            multiVmGroupName = javaType.multiVmGroupName().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            primaryAvailabilityZone = javaType.primaryAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            primaryExtendedLocation = javaType.primaryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            protectedManagedDisks = javaType.protectedManagedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AProtectedManagedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            recoveryAvailabilitySet = javaType.recoveryAvailabilitySet().map({ args0 -> args0 }).orElse(null),
            recoveryAvailabilityZone = javaType.recoveryAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            recoveryAzureGeneration = javaType.recoveryAzureGeneration(),
            recoveryAzureResourceGroupId = javaType.recoveryAzureResourceGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureVMName = javaType.recoveryAzureVMName().map({ args0 -> args0 }).orElse(null),
            recoveryAzureVMSize = javaType.recoveryAzureVMSize().map({ args0 -> args0 }).orElse(null),
            recoveryBootDiagStorageAccountId = javaType.recoveryBootDiagStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryCapacityReservationGroupId = javaType.recoveryCapacityReservationGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryCloudService = javaType.recoveryCloudService().map({ args0 -> args0 }).orElse(null),
            recoveryExtendedLocation = javaType.recoveryExtendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryFabricLocation = javaType.recoveryFabricLocation().map({ args0 -> args0 }).orElse(null),
            recoveryFabricObjectId = javaType.recoveryFabricObjectId().map({ args0 -> args0 }).orElse(null),
            recoveryProximityPlacementGroupId = javaType.recoveryProximityPlacementGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryVirtualMachineScaleSetId = javaType.recoveryVirtualMachineScaleSetId().map({ args0 ->
                args0
            }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            selectedRecoveryAzureNetworkId = javaType.selectedRecoveryAzureNetworkId().map({ args0 ->
                args0
            }).orElse(null),
            selectedTfoAzureNetworkId = javaType.selectedTfoAzureNetworkId().map({ args0 ->
                args0
            }).orElse(null),
            testFailoverRecoveryFabricObjectId = javaType.testFailoverRecoveryFabricObjectId().map({ args0 ->
                args0
            }).orElse(null),
            tfoAzureVMName = javaType.tfoAzureVMName().map({ args0 -> args0 }).orElse(null),
            unprotectedDisks = javaType.unprotectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AUnprotectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmEncryptionType = javaType.vmEncryptionType(),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
            vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
            vmSyncedConfigDetails = javaType.vmSyncedConfigDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AzureToAzureVmSyncedConfigDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
