@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * A2A provider specific settings.
 * @property clusterManagementId The cluster management Id.
 * @property failoverRecoveryPointId The recovery point Id to which the cluster was failed over.
 * @property initialPrimaryExtendedLocation The initial primary extended location.
 * @property initialPrimaryFabricLocation The initial primary fabric location.
 * @property initialPrimaryZone The initial primary availability zone.
 * @property initialRecoveryExtendedLocation The initial recovery extended location.
 * @property initialRecoveryFabricLocation The initial recovery fabric location.
 * @property initialRecoveryZone The initial recovery availability zone.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property lastRpoCalculatedTime The time (in UTC) when the last RPO value was calculated by Protection Service.
 * @property lifecycleId An id that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected cluster even though other internal Ids/ARM Id might be changing.
 * @property multiVmGroupCreateOption Whether Multi VM group is auto created or specified by user.
 * @property multiVmGroupId The multi vm group Id.
 * @property multiVmGroupName The multi vm group name.
 * @property primaryAvailabilityZone The primary availability zone.
 * @property primaryExtendedLocation The primary Extended Location.
 * @property primaryFabricLocation Primary fabric location.
 * @property recoveryAvailabilityZone The recovery availability zone.
 * @property recoveryExtendedLocation The recovery Extended Location.
 * @property recoveryFabricLocation The recovery fabric location.
 * @property rpoInSeconds The last RPO value in seconds.
 */
public data class A2AReplicationProtectionClusterDetailsResponse(
    public val clusterManagementId: String? = null,
    public val failoverRecoveryPointId: String? = null,
    public val initialPrimaryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialPrimaryFabricLocation: String? = null,
    public val initialPrimaryZone: String? = null,
    public val initialRecoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val initialRecoveryFabricLocation: String? = null,
    public val initialRecoveryZone: String? = null,
    public val instanceType: String,
    public val lastRpoCalculatedTime: String? = null,
    public val lifecycleId: String? = null,
    public val multiVmGroupCreateOption: String? = null,
    public val multiVmGroupId: String? = null,
    public val multiVmGroupName: String? = null,
    public val primaryAvailabilityZone: String? = null,
    public val primaryExtendedLocation: ExtendedLocationResponse? = null,
    public val primaryFabricLocation: String? = null,
    public val recoveryAvailabilityZone: String? = null,
    public val recoveryExtendedLocation: ExtendedLocationResponse? = null,
    public val recoveryFabricLocation: String? = null,
    public val rpoInSeconds: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AReplicationProtectionClusterDetailsResponse): A2AReplicationProtectionClusterDetailsResponse =
            A2AReplicationProtectionClusterDetailsResponse(
                clusterManagementId = javaType.clusterManagementId().map({ args0 -> args0 }).orElse(null),
                failoverRecoveryPointId = javaType.failoverRecoveryPointId().map({ args0 -> args0 }).orElse(null),
                initialPrimaryExtendedLocation = javaType.initialPrimaryExtendedLocation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                initialPrimaryFabricLocation = javaType.initialPrimaryFabricLocation().map({ args0 ->
                    args0
                }).orElse(null),
                initialPrimaryZone = javaType.initialPrimaryZone().map({ args0 -> args0 }).orElse(null),
                initialRecoveryExtendedLocation = javaType.initialRecoveryExtendedLocation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                initialRecoveryFabricLocation = javaType.initialRecoveryFabricLocation().map({ args0 ->
                    args0
                }).orElse(null),
                initialRecoveryZone = javaType.initialRecoveryZone().map({ args0 -> args0 }).orElse(null),
                instanceType = javaType.instanceType(),
                lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
                lifecycleId = javaType.lifecycleId().map({ args0 -> args0 }).orElse(null),
                multiVmGroupCreateOption = javaType.multiVmGroupCreateOption().map({ args0 -> args0 }).orElse(null),
                multiVmGroupId = javaType.multiVmGroupId().map({ args0 -> args0 }).orElse(null),
                multiVmGroupName = javaType.multiVmGroupName().map({ args0 -> args0 }).orElse(null),
                primaryAvailabilityZone = javaType.primaryAvailabilityZone().map({ args0 -> args0 }).orElse(null),
                primaryExtendedLocation = javaType.primaryExtendedLocation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
                recoveryAvailabilityZone = javaType.recoveryAvailabilityZone().map({ args0 -> args0 }).orElse(null),
                recoveryExtendedLocation = javaType.recoveryExtendedLocation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                recoveryFabricLocation = javaType.recoveryFabricLocation().map({ args0 -> args0 }).orElse(null),
                rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            )
    }
}
