@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extended location of the resource.
 * @property errorCode The error code.
 * @property errorCodeEnum The error code enum.
 * @property errorMessage The error message.
 * @property possibleCauses The possible causes.
 * @property recommendedAction The recommended action.
 */
public data class A2ASharedDiskIRErrorDetailsResponse(
    public val errorCode: String,
    public val errorCodeEnum: String,
    public val errorMessage: String,
    public val possibleCauses: String,
    public val recommendedAction: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2ASharedDiskIRErrorDetailsResponse): A2ASharedDiskIRErrorDetailsResponse = A2ASharedDiskIRErrorDetailsResponse(
            errorCode = javaType.errorCode(),
            errorCodeEnum = javaType.errorCodeEnum(),
            errorMessage = javaType.errorMessage(),
            possibleCauses = javaType.possibleCauses(),
            recommendedAction = javaType.recommendedAction(),
        )
    }
}
