@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A2A provider specific settings.
 * @property failoverRecoveryPointId The recovery point id to which the Virtual node was failed over.
 * @property instanceType Gets the Instance type.
 * Expected value is 'A2A'.
 * @property lastRpoCalculatedTime The time (in UTC) when the last RPO value was calculated by Protection Service.
 * @property managementId The management Id.
 * @property monitoringJobType The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
 * @property monitoringPercentageCompletion The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
 * @property primaryFabricLocation Primary fabric location.
 * @property protectedManagedDisks The list of protected managed disks.
 * @property recoveryFabricLocation The recovery fabric location.
 * @property rpoInSeconds The last RPO value in seconds.
 * @property sharedDiskIRErrors The IR Errors.
 * @property unprotectedDisks The list of unprotected disks.
 */
public data class A2ASharedDiskReplicationDetailsResponse(
    public val failoverRecoveryPointId: String? = null,
    public val instanceType: String,
    public val lastRpoCalculatedTime: String? = null,
    public val managementId: String? = null,
    public val monitoringJobType: String? = null,
    public val monitoringPercentageCompletion: Int? = null,
    public val primaryFabricLocation: String? = null,
    public val protectedManagedDisks: List<A2AProtectedManagedDiskDetailsResponse>? = null,
    public val recoveryFabricLocation: String? = null,
    public val rpoInSeconds: Double? = null,
    public val sharedDiskIRErrors: List<A2ASharedDiskIRErrorDetailsResponse>? = null,
    public val unprotectedDisks: List<A2AUnprotectedDiskDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2ASharedDiskReplicationDetailsResponse): A2ASharedDiskReplicationDetailsResponse = A2ASharedDiskReplicationDetailsResponse(
            failoverRecoveryPointId = javaType.failoverRecoveryPointId().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            managementId = javaType.managementId().map({ args0 -> args0 }).orElse(null),
            monitoringJobType = javaType.monitoringJobType().map({ args0 -> args0 }).orElse(null),
            monitoringPercentageCompletion = javaType.monitoringPercentageCompletion().map({ args0 ->
                args0
            }).orElse(null),
            primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
            protectedManagedDisks = javaType.protectedManagedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AProtectedManagedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            recoveryFabricLocation = javaType.recoveryFabricLocation().map({ args0 -> args0 }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            sharedDiskIRErrors = javaType.sharedDiskIRErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2ASharedDiskIRErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            unprotectedDisks = javaType.unprotectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AUnprotectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
