@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Zone details data.
 * @property source Source zone info.
 * @property target The target zone info.
 */
public data class A2AZoneDetailsResponse(
    public val source: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.A2AZoneDetailsResponse): A2AZoneDetailsResponse = A2AZoneDetailsResponse(
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
