@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Agent disk details.
 * @property capacityInBytes The disk capacity in bytes.
 * @property diskId The disk Id.
 * @property diskName The disk name.
 * @property isOSDisk A value indicating whether the disk is the OS disk.
 * @property lunId The lun of disk.
 */
public data class AgentDiskDetailsResponse(
    public val capacityInBytes: Double,
    public val diskId: String,
    public val diskName: String,
    public val isOSDisk: String,
    public val lunId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AgentDiskDetailsResponse): AgentDiskDetailsResponse = AgentDiskDetailsResponse(
            capacityInBytes = javaType.capacityInBytes(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            isOSDisk = javaType.isOSDisk(),
            lunId = javaType.lunId(),
        )
    }
}
