@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure Fabric Specific Details.
 * @property containerIds The container Ids for the Azure fabric.
 * @property extendedLocations The ExtendedLocations.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'Azure'.
 * @property location The Location for the Azure fabric.
 * @property locationDetails The location details.
 * @property zones The zones.
 */
public data class AzureFabricSpecificDetailsResponse(
    public val containerIds: List<String>? = null,
    public val extendedLocations: List<A2AExtendedLocationDetailsResponse>? = null,
    public val instanceType: String,
    public val location: String? = null,
    public val locationDetails: List<A2AFabricSpecificLocationDetailsResponse>? = null,
    public val zones: List<A2AZoneDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureFabricSpecificDetailsResponse): AzureFabricSpecificDetailsResponse = AzureFabricSpecificDetailsResponse(
            containerIds = javaType.containerIds().map({ args0 -> args0 }),
            extendedLocations = javaType.extendedLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AExtendedLocationDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            locationDetails = javaType.locationDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AFabricSpecificLocationDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AZoneDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
